/*
 * Decompiled with CFR 0.152.
 */
package cn.asens.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtils {
    public static String getProperty(String location, String key) {
        InputStream is = PropertyUtils.getLocationFile(location);
        try {
            return PropertyUtils.getConfigMap(is).get(key);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static InputStream getLocationFile(String location) {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        if (is == null || location.startsWith("/")) {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(location.substring(1));
        }
        throw new IllegalStateException("file not found");
    }

    public static Map<String, String> getConfigMap(InputStream is) throws IOException {
        LinkedHashMap<String, String> config = new LinkedHashMap<String, String>();
        List<String> list = PropertyUtils.readFileAsList(is);
        for (String line : list) {
            if (line.startsWith("#") || PropertyUtils.isWhiteSpace(line) || !line.contains("=")) continue;
            int fd = line.indexOf("=");
            String key = line.substring(0, fd);
            String value = line.substring(fd + 1);
            config.put(key, value);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readFileAsList(InputStream is) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String str;
            isr = new InputStreamReader(is, "utf-8");
            br = new BufferedReader(isr);
            while ((str = br.readLine()) != null) {
                list.add(str);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return list;
    }

    private static boolean isWhiteSpace(String line) {
        return line.replace(" ", "").equals("");
    }
}

