package cn.asens.entity;

import java.util.Date;

/**
 * 初次使用需要同步全部订单过来
 * 以后生成订单时同步一次，支付订单时也要同步一次
 * 推荐定时任务每个一段时间全部同步一次，防止错误或遗漏
 * 本地的orderId作为唯一标识符，第一次同步会保存，第二次同步会更新订单信息
 * 已支付订单的price一定是用户实际支付的金额，如果本地订单的虚拟金额和实际金额混在一起了
 * 要先判断支付方式在确定金额，全部使用代币支付的price为0
 * 部分代币（会员卡）+现金支付的也要去掉代币的部分，计算出实际的支付金额
 *
 * @author Asens
 */

public class CountUserOrder {
    /**
     * 订单ID，唯一标识符
     */
    private String orderId;
    /**
     * 本地订单号
     */
    private String orderNo;
    /**
     * 第三方订单号
     */
    private String thirdTradeNo;
    /**
     * 支付方式
     */
    private Integer payChannel;
    /**
     * 购买了什么
     */
    private String productName;
    /**
     * 创建订单时间
     */
    private Date createDate;
    /**
     * 购买类型
     */
    private Integer type;
    /**
     * 是否付款
     */
    private Integer status;
    /**
     * 实际付款金额
     */
    private Double price;
    /**
     * 用户ID
     */
    private Integer userId;
    /**
     * 是否为机构订单
     */
    private Integer org;
    /**
     * 是否为试用
     */


    private Integer isTry;

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getThirdTradeNo() {
        return thirdTradeNo;
    }

    public void setThirdTradeNo(String thirdTradeNo) {
        this.thirdTradeNo = thirdTradeNo;
    }

    public Integer getPayChannel() {
        return payChannel;
    }

    public void setPayChannel(Integer payChannel) {
        this.payChannel = payChannel;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Double getPrice() {
        return price;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public Integer getOrg() {
        return org;
    }

    public void setOrg(Integer org) {
        this.org = org;
    }

    public Integer getIsTry() {
        return isTry;
    }

    public void setIsTry(Integer isTry) {
        this.isTry = isTry;
    }
}
