/*
 * Decompiled with CFR 0.152.
 */
package cn.asens;

import cn.asens.entity.CountUser;
import cn.asens.entity.CountUserOrder;
import cn.asens.entity.Resource;
import cn.asens.entity.ViewLog;
import cn.asens.filter.CountFilter;
import cn.asens.util.PropertyUtils;
import cn.asens.util.https.HttpUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Count {
    private static Logger log = LoggerFactory.getLogger(Count.class);
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private static String countHost = PropertyUtils.getProperty("/config/count_config.ini", "countHost");
    private static String appId = PropertyUtils.getProperty("/config/count_config.ini", "appId");
    private static List<CountFilter> filterList = new ArrayList<CountFilter>();
    public static final String API_VIEW_LOG = "/viewLog";
    public static final String API_ORDER = "/order";
    public static final String API_RESOURCE = "/resource";
    public static final String API_USER = "/userInfo";
    public static final String API_PERFORMANCE = "/performance";
    public static final String API_INSTITUTION_DATA = "/institutionData";
    public static final String API_ORDERS = "/orders";
    public static final String API_RESOURCES = "/resources";
    public static final String API_USERS = "/userInfos";

    public static void asyncViewLog(ViewLog viewLog) {
        EXECUTOR_SERVICE.execute(new MessageTask(viewLog, API_VIEW_LOG));
    }

    public static void asyncResource(Resource resource) {
        EXECUTOR_SERVICE.execute(new MessageTask(resource, API_RESOURCE));
    }

    public static void asyncOrder(CountUserOrder countUserOrder) {
        EXECUTOR_SERVICE.execute(new MessageTask(countUserOrder, API_ORDER));
    }

    public static void asyncUser(CountUser countUser) {
        EXECUTOR_SERVICE.execute(new MessageTask(countUser, API_USER));
    }

    public static boolean syncOrders(List<CountUserOrder> orderList) {
        return Count.syncList(orderList, API_ORDERS);
    }

    public static boolean syncUsers(List<CountUser> countUserList) {
        return Count.syncList(countUserList, API_USERS);
    }

    public static boolean syncResources(List<Resource> resourceList) {
        return Count.syncList(resourceList, API_RESOURCES);
    }

    public static String institutionData(String json) {
        return HttpUtils.doPost(countHost + API_INSTITUTION_DATA, json);
    }

    public static String appId() {
        return appId;
    }

    public static String host() {
        return countHost;
    }

    public static void setCountHost(String countHost) {
        Count.countHost = countHost;
    }

    public static void setAppId(String appId) {
        Count.appId = appId;
    }

    private static String syncEntity(Object o, String api) {
        log.debug("countHost + api : " + countHost + api);
        return HttpUtils.doPost(countHost + api, JSON.toJSONString((Object)o));
    }

    private static boolean syncList(List<?> list, String api) {
        try {
            String json = JSON.toJSONString(list);
            JSONArray array = JSON.parseArray((String)json);
            int l = array.size();
            for (int i = 0; i < l; ++i) {
                JSONObject t = JSON.parseObject((String)array.get(i).toString());
                if (t.get((Object)"appId") == null) {
                    t.put("appId", (Object)appId);
                }
                String tJson = t.toJSONString();
                for (CountFilter filter : filterList) {
                    tJson = filter.handle(tJson, api);
                }
                array.set(i, (Object)tJson);
            }
            String result = HttpUtils.doPost(countHost + api, array.toJSONString());
            return "success".equals(result);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void addFilter(CountFilter countFilter) {
        filterList.add(countFilter);
    }

    private static class MessageTask
    extends Thread {
        private Object o;
        private String api;

        private MessageTask(Object o, String api) {
            this.o = o;
            this.api = api;
            this.init();
        }

        private void init() {
            String json = JSON.toJSONString((Object)this.o);
            JSONObject t = JSON.parseObject((String)json);
            if (t.get((Object)"appId") == null) {
                t.put("appId", (Object)appId);
            }
            json = t.toJSONString();
            for (CountFilter filter : filterList) {
                json = filter.handle(json, this.api);
            }
            this.o = JSON.parse((String)json);
        }

        public void run() {
            try {
                String result = Count.syncEntity(this.o, this.api);
                log.info("MessageTask result:" + result);
            }
            catch (Exception e) {
                log.error("MessageTask error:" + e.getMessage());
            }
        }
    }
}

