package cn.asens.util.https;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.util.EntityUtils;

import java.io.IOException;

/**
 * Created by Asens on 2017/7/7
 */
public class HttpUtils {

    private static DefaultHttpClient httpClient = null;

    private final static Object syncLock = new Object();

    /**
     * 获取HttpClient对象
     */
    private static DefaultHttpClient getHttpClient(String url) {
        String hostname = url.split("/")[2];
        int port = 80;
        if (hostname.contains(":")) {
            String[] arr = hostname.split(":");
            hostname = arr[0];
            port = Integer.parseInt(arr[1]);
        }
        if (httpClient == null) {
            synchronized (syncLock) {
                if (httpClient == null) {
                    httpClient = createHttpClient(200, 40, 100, hostname, port);
                }
            }
        }
        return httpClient;
    }

    /**
     * 创建HttpClient对象
     */
    private static DefaultHttpClient createHttpClient(int maxTotal,
                                                      int maxPerRoute, int maxRoute, String hostname, int port) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, SSLSocketFactory.getSocketFactory()));
        ThreadSafeClientConnManager ccm=new ThreadSafeClientConnManager(schemeRegistry);
        ccm.setDefaultMaxPerRoute(maxPerRoute);
        ccm.setMaxTotal(maxTotal);
        HttpHost httpHost = new HttpHost(hostname, port);
        ccm.setMaxForRoute(new HttpRoute(httpHost), maxRoute);
        return new DefaultHttpClient(ccm);
    }


    /**
     * POST请求URL获取内容
     */
    public static String doPost(String url, String json) {
        HttpPost httppost = new HttpPost(url);
        HttpResponse response;
        String result=null;
        try {
            StringEntity s = new StringEntity(json, "UTF-8");
            s.setContentType("application/json");//发送json数据需要设置contentType
            httppost.setEntity(s);
            response = getHttpClient(url).execute(httppost);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString(entity, "utf-8");
            EntityUtils.consume(entity);
            return result;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

}
