package cn.asens.util;

import java.util.*;


public class CollectionUtils {

    public static Map<String, String> arrListToMap(List<Object[]> list) {
        Map<String,String> map=new LinkedHashMap<String,String>();
        for(Object[] arr:list){
            map.put(arr[0].toString(),arr[1].toString());
        }
        return map;
    }

    public static Map<String, String> arrListToMap(List<Object[]> list, int limit) {
        Map<String,String> map=new LinkedHashMap<String,String>();
        int count=0;
        for(Object[] arr:list){
            map.put(arr[0].toString(),arr[1].toString());
            if(count++>limit){
                break;
            }
        }
        return map;
    }

    public static Map<String, Integer> arrListToMapInt(List<Object[]> list) {
        Map<String,Integer> map=new LinkedHashMap<String,Integer>();
        for(Object[] arr:list){
            map.put(arr[0].toString(),Integer.valueOf(arr[1].toString()));
        }
        return map;
    }

    public static Map<String,String> addMonthZero(List<Object[]> list){
        Map<String,String> map=new LinkedHashMap<String,String>();
        for(int i = 1; i < 13; i++){
            boolean exist=false;
            for (Object[] arr:list) {
                if(arr[0].toString().equals(String.valueOf(i))){
                    map.put(arr[0].toString(),arr[1].toString());
                    exist=true;
                }
            }
            if(!exist){
                map.put(String.valueOf(i),"0");
            }
        }
        return map;
    }



    public static Map<String, Integer> sortMap(Map<String, Integer> recommendMap) {
        Map<String, Integer> result=new LinkedHashMap<String, Integer>();
        List<Wrapper> list=new ArrayList<Wrapper>(result.size());
        for(String key:recommendMap.keySet()){
            list.add(new Wrapper(key,recommendMap.get(key)));
        }
        Collections.sort(list);
        Collections.reverse(list);
        for(Wrapper wrapper:list){
            result.put(wrapper.key,wrapper.num);
        }
        return result;
    }

    private static class Wrapper implements Comparable<Wrapper> {
        private String key;
        private Integer num;

        public Wrapper(String key, Integer num) {
            this.key = key;
            this.num = num;
        }

        public int compareTo(Wrapper o) {
            return num-o.num;
        }
    }
}
