package cn.asens.entity;

import java.util.Calendar;
import java.util.Date;


public class ViewLog {
    public final static Integer TYPE_LOGIN=0;
    //访问资源
    public final static Integer TYPE_ITEM=1;
    public final static Integer TYPE_SEARCH=2;
    public final static Integer TYPE_VIEW=3;
    public final static Integer TYPE_REGISTER=4;
    public final static int TYPE_COLLECT=5;
    public final static int TYPE_PRE_ORDER=6;
    public final static int TYPE_ORDER=7;
    public final static int TYPE_REJECT=14;

    //检索的子集合
    /**
     * 在下列事件中需要记录两个事件，一个检索TYPE_SEARCH，一个具体的检索
     * 都需要记录内容，高级检索以分号隔开
     * 普通检索（全文） 普通检索（书刊）
     * 高级检索（全文） 高级检索（书刊）
     * 专业检索 二次检索
     */
    public final static int TYPE_NORMAL_SEARCH_CONTENT=8;
    public final static int TYPE_NORMAL_SEARCH_TITLE=9;
    public final static int TYPE_ADVANCE_SEARCH_CONTENT=10;
    public final static int TYPE_ADVANCE_SEARCH_TITLE=11;
    public final static int TYPE_PROFESSIONAL_SEARCH=12;
    public final static int TYPE_TWICE_SEARCH=13;

    public final static int VIEW_CHANNEL_PC=0;
    public final static int VIEW_CHANNEL_WEIXIN=1;

    public final static int REJECT_NO_AUTH=0;
    public final static int REJECT_CONCURRENT=1;

    //文章阅读页面右键几个菜单的点击事件
    //笔记
    public final static Integer TYPE_ADD_NOTE=1001;
    //复制
    public final static int TYPE_COPY=1002;
    //引用
    public final static int TYPE_QUOTE=1003;
    //右键检索
    public final static int TYPE_RIGHT_SEARCH=1004;
    //联机字典
    public final static int TYPE_DICTIONARY=1005;

    private Integer id;

    private Integer type;

    private String username;

    private Integer userId;

    private Date viewDate;

    private Integer itemId;

    private String ip;

    private Integer institutionId;

    private String institutionName;

    private String title;

    private Integer viewYear;

    private Integer viewMonth;

    private Integer viewDay;

    private String referer;

    private Integer viewChannel;

    private String otherInfo;


    public ViewLog() {}

    private ViewLog(Builder builder) {
        this.type=builder.type;
        this.username=builder.username;
        this.userId=builder.userId;
        this.viewDate=builder.viewDate;
        this.itemId=builder.itemId;
        this.ip=builder.ip;
        this.institutionId=builder.institutionId;
        this.title=builder.title;
        this.referer=builder.referer;
        this.otherInfo=builder.otherInfo;
        this.institutionName=builder.institutionName;
        Calendar calendar=Calendar.getInstance();
        calendar.setTime(viewDate);
        this.viewYear=calendar.get(Calendar.YEAR);
        this.viewMonth=calendar.get(Calendar.MONTH)+1;
        this.viewDay=calendar.get(Calendar.DAY_OF_MONTH);
        this.viewChannel=ViewLog.VIEW_CHANNEL_PC;
    }

    public static Builder builder(){
        return new Builder();
    }

    public static class Builder{
        private Integer type;
        private String username;
        private Integer userId;
        private Date viewDate;
        private Integer itemId;
        private String ip;
        private Integer institutionId;
        private String title;
        private String institutionName;
        private String referer;
        private String otherInfo;

        public Builder type(Integer type) {
            this.type = type;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder otherInfo(String otherInfo) {
            this.otherInfo = otherInfo;
            return this;
        }

        public Builder referer(String referer) {
            this.referer = referer;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder userId(Integer userId) {
            this.userId = userId;
            return this;
        }

        public Builder itemId(Integer itemId) {
            this.itemId = itemId;
            return this;
        }

        public Builder ip(String ip) {
            this.ip = ip;
            return this;
        }

        public Builder institutionId(Integer institutionId) {
            this.institutionId = institutionId;
            return this;
        }

        public Builder institutionName(String institutionName) {
            this.institutionName = institutionName;
            return this;
        }

        public ViewLog build(){
            this.viewDate = new Date();
            return new ViewLog(this);
        }


    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public Date getViewDate() {
        return viewDate;
    }

    public void setViewDate(Date viewDate) {
        this.viewDate = viewDate;
    }

    public Integer getItemId() {
        return itemId;
    }

    public void setItemId(Integer itemId) {
        this.itemId = itemId;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Integer getInstitutionId() {
        return institutionId;
    }

    public void setInstitutionId(Integer institutionId) {
        this.institutionId = institutionId;
    }

    public Integer getViewChannel() {
        return viewChannel;
    }

    public void setViewChannel(Integer viewChannel) {
        this.viewChannel = viewChannel;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Integer getViewYear() {
        return viewYear;
    }

    public void setViewYear(Integer viewYear) {
        this.viewYear = viewYear;
    }

    public Integer getViewMonth() {
        return viewMonth;
    }

    public void setViewMonth(Integer viewMonth) {
        this.viewMonth = viewMonth;
    }

    public Integer getViewDay() {
        return viewDay;
    }

    public void setViewDay(Integer viewDay) {
        this.viewDay = viewDay;
    }

    public String getInstitutionName() {
        return institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public String getReferer() {
        return referer;
    }

    public void setReferer(String referer) {
        this.referer = referer;
    }

    public String getOtherInfo() {
        return otherInfo;
    }

    public void setOtherInfo(String otherInfo) {
        this.otherInfo = otherInfo;
    }
}
