package cn.asens;

import cn.asens.entity.*;
import cn.asens.util.PropertyUtils;
import cn.asens.util.https.HttpUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author Asens
 */

public class Count {
    private static Logger log=LoggerFactory.getLogger(Count.class);

    private final static ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool
            (Runtime.getRuntime().availableProcessors());
    
    private static String countHost=PropertyUtils
            .getProperty("/config/count_config.ini","countHost");

    private static String appId=PropertyUtils
            .getProperty("/config/count_config.ini","appId");;

    private final static String API_VIEW_LOG = "/viewLog";
    private final static String API_ORDER = "/order";
    private final static String API_RESOURCE = "/resource";
    private final static String API_USER = "/userInfo";
    private final static String API_PERFORMANCE = "/performance";
    private final static String API_INSTITUTION_DATA = "/institutionData";


    private final static String API_ORDERS = "/orders";
    private final static String API_RESOURCES = "/resources";
    private final static String API_USERS = "/userInfos";

    public static void asyncViewLog(ViewLog viewLog) {
        EXECUTOR_SERVICE.execute(new MessageTask(viewLog, API_VIEW_LOG));
    }

    public static void asyncResource(Resource resource) {
        EXECUTOR_SERVICE.execute(new MessageTask(resource, API_RESOURCE));
    }

    public static void asyncOrder(CountUserOrder countUserOrder) {
        EXECUTOR_SERVICE.execute(new MessageTask(countUserOrder, API_ORDER));
    }

    public static void asyncUser(CountUser countUser) {
        EXECUTOR_SERVICE.execute(new MessageTask(countUser, API_USER));
    }

    public static boolean syncOrders(List<CountUserOrder> orderList) {
        return syncList(orderList, API_ORDERS);
    }

    public static boolean syncUsers(List<CountUser> countUserList) {
        return syncList(countUserList, API_USERS);
    }

    public static boolean syncResources(List<Resource> resourceList) {
        return syncList(resourceList, API_RESOURCES);
    }

    public static String institutionData(String json) {
        return HttpUtils.doPost(countHost + API_INSTITUTION_DATA, json);
    }

    public static String appId() {
        return appId;
    }


    private static class MessageTask extends Thread {
        private Object o;
        private String api;

        private MessageTask(Object o, String api) {
            this.o = o;
            this.api = api;
        }

        @Override
        public void run() {
            try {
                String result = syncEntity(o, api);
                log.info("MessageTask result:" + result);
            } catch (Exception e) {
                log.error("MessageTask error:" + e.getMessage());
            }

        }
    }

    private static String syncEntity(Object o, String api) {
        String json = JSON.toJSONString(o);
        JSONObject t = JSON.parseObject(json);
        t.put("appId", appId);
        json = t.toJSONString();
        log.debug("countHost + api : "+(countHost + api));
        return HttpUtils.doPost(countHost + api, json);
    }

    private static boolean syncList(List<?> list, String api) {
        try {
            String json = JSON.toJSONString(list);
            JSONArray array = JSON.parseArray(json);
            for (int i = 0, l = array.size(); i < l; i++) {
                JSONObject t = JSON.parseObject(array.get(i).toString());
                t.put("appId", appId);
                array.set(i, t.toJSONString());
            }
            String result=HttpUtils.doPost(countHost + api, array.toJSONString());
            return result.equals("success");
        } catch (Exception e) {
            return false;
        }
    }

}
