/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.storage.graphql.directives;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import lombok.Generated;
import org.apache.commons.net.util.Base64;
import org.jfantasy.framework.util.common.ClassUtil;
import org.jfantasy.storage.FileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class FileObjectFormatDirective
implements SchemaDirectiveWiring {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileObjectFormatDirective.class);
    @Value(value="${storage.url}")
    private String storageUrl;

    public GraphQLFieldDefinition onField(SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
        GraphQLFieldDefinition field = (GraphQLFieldDefinition)environment.getElement();
        DataFetcher originalDataFetcher = (DataFetcher)ClassUtil.call((String)"getDataFetcher", (Object)field);
        DataFetcher dataFetcher = DataFetcherFactories.wrapDataFetcher((DataFetcher)originalDataFetcher, (dataFetchingEnvironment, value) -> {
            String type = (String)dataFetchingEnvironment.getArgument("format");
            if (value instanceof FileObject && type != null && !"object".equals(type)) {
                return this.buildFileObject((FileObject)value, type);
            }
            return value;
        });
        return field.transform(builder -> builder.argument(GraphQLArgument.newArgument().name("format").type((GraphQLInputType)Scalars.GraphQLString).type((GraphQLInputType)GraphQLEnumType.newEnum().name("FileEnum").description("\u6587\u4ef6\u81ea\u5b9a\u5728\u683c\u5f0f").value("base64", (Object)"base64", "\u4ec5\u652f\u6301\u56fe\u7247").value("url", (Object)"url", "\u81ea\u52a8\u6dfb\u52a0\u4e0a\u57df\u540d").value("object", (Object)"object", "\u9ed8\u8ba4\u683c\u5f0f").build()).description("\u6587\u4ef6\u81ea\u5b9a\u5728\u683c\u5f0f")).dataFetcher(dataFetcher));
    }

    private String buildFileObject(FileObject fileObject, String type) {
        String str = this.storageUrl + fileObject.getPath();
        if ("base64".equals(type)) {
            str = FileObjectFormatDirective.getImageBase64ByFileObject(fileObject, str);
        }
        return str;
    }

    public static String getImageBase64ByFileObject(FileObject fileObject, String url) {
        if (fileObject.getLength() > 5191680L) {
            return null;
        }
        if (!"image".equals(fileObject.getMimeType().substring(0, 5))) {
            return null;
        }
        try {
            return "data:" + fileObject.getMimeType() + ";base64," + FileObjectFormatDirective.ImageToBase64ByOnline(url);
        }
        catch (IOException e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public static String ImageToBase64ByOnline(String imgURL) throws IOException {
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        URL url = new URL(imgURL);
        byte[] by = new byte[1024];
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5000);
        InputStream is = conn.getInputStream();
        int len = -1;
        while ((len = is.read(by)) != -1) {
            data.write(by, 0, len);
        }
        is.close();
        return new String(Base64.encodeBase64((byte[])data.toByteArray()));
    }
}

