/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.storage.graphql.scalars;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import graphql.language.StringValue;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import lombok.Generated;
import org.jfantasy.storage.FileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileObjectCoercing
implements Coercing<FileObject, Object> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileObjectCoercing.class);
    private String fileServerUrl;

    public FileObjectCoercing(String fileServerUrl) {
        this.fileServerUrl = fileServerUrl;
    }

    public Object serialize(Object input) throws CoercingSerializeException {
        return input instanceof FileObject ? input : input;
    }

    public FileObject parseValue(Object input) throws CoercingParseValueException {
        String fileId = null;
        if (input instanceof String) {
            fileId = input.toString();
        }
        if (input instanceof StringValue) {
            fileId = ((StringValue)input).getValue();
        }
        if (fileId == null) {
            return null;
        }
        try {
            HttpResponse response = Unirest.get((String)(this.fileServerUrl + "/files/" + fileId)).asObject(FileObject.class);
            return (FileObject)response.getBody();
        }
        catch (UnirestException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public FileObject parseLiteral(Object input) throws CoercingParseLiteralException {
        return this.parseValue(input);
    }
}

