/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.graphql.inputs;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfantasy.framework.dao.hibernate.util.ReflectionUtils;
import org.jfantasy.framework.dao.jpa.PropertyFilter;
import org.jfantasy.framework.dao.jpa.PropertyFilterBuilder;
import org.jfantasy.framework.util.common.ClassUtil;
import org.jfantasy.framework.util.common.ObjectUtil;
import org.jfantasy.framework.util.common.StringUtil;
import org.jfantasy.graphql.inputs.DefaultTypeConverter;
import org.jfantasy.graphql.inputs.TypeConverter;

public abstract class QueryFilter<F extends QueryFilter, T> {
    private final Class<T> entityClass;
    private final Map<String, TypeConverter> fields = new HashMap<String, TypeConverter>();
    protected PropertyFilterBuilder builder = new PropertyFilterBuilder();

    public QueryFilter() {
        this.entityClass = ReflectionUtils.getSuperClassGenricType(this.getClass(), (int)1);
        if (this.entityClass == Object.class) {
            return;
        }
        for (Field field : ClassUtil.getDeclaredFields(this.entityClass)) {
            if (!ClassUtil.isBasicType(field.getType())) continue;
            this.fields.put(field.getName(), new DefaultTypeConverter(field.getType()));
        }
    }

    protected void register(String name, TypeConverter converter) {
        this.fields.put(name, converter);
    }

    @JsonProperty(value="AND")
    public void setAnd(F[] filters) {
        this.builder.and((PropertyFilterBuilder[])Arrays.stream(filters).map(item -> item.builder).toArray(PropertyFilterBuilder[]::new));
    }

    @JsonProperty(value="OR")
    public void setOr(F[] filters) {
        this.builder.or((PropertyFilterBuilder[])Arrays.stream(filters).map(item -> item.builder).toArray(PropertyFilterBuilder[]::new));
    }

    @JsonProperty(value="NOT")
    public void setNot(F[] filters) {
        this.builder.not((PropertyFilterBuilder[])Arrays.stream(filters).map(item -> item.builder).toArray(PropertyFilterBuilder[]::new));
    }

    @JsonAnySetter
    public void set(String name, Object value) {
        String[] slugs = StringUtil.tokenizeToStringArray((String)name, (String)"_");
        Object newValue = slugs.length > 1 && ObjectUtil.exists((Object[])new String[]{"in", "notIn"}, (Object)slugs[1]) != false ? Arrays.stream(ObjectUtil.multipleValuesObjectsObjects((Object)value)).map(item -> this.fields.get(slugs[0]).convert(item)).toArray(Object[]::new) : this.fields.get(slugs[0]).convert(value);
        if (slugs.length == 1) {
            this.builder.equal(name, newValue);
            return;
        }
        PropertyFilter.MatchType.get((String)slugs[1]).build(this.builder, slugs[0], newValue);
    }

    public PropertyFilterBuilder getBuilder() {
        return this.builder;
    }

    public List<PropertyFilter> build() {
        return this.builder.build();
    }
}

