/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.graphql.directives;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputType;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.jfantasy.framework.util.common.ClassUtil;
import org.jfantasy.framework.util.common.StringUtil;

public class DateFormatDirective
implements SchemaDirectiveWiring {
    public GraphQLFieldDefinition onField(SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
        GraphQLFieldDefinition field = (GraphQLFieldDefinition)environment.getElement();
        DataFetcher originalDataFetcher = (DataFetcher)ClassUtil.call((String)"getDataFetcher", (Object)field);
        DataFetcher dataFetcher = DataFetcherFactories.wrapDataFetcher((DataFetcher)originalDataFetcher, (dataFetchingEnvironment, value) -> {
            String format = (String)dataFetchingEnvironment.getArgument("format");
            if (StringUtil.isBlank((Object)format)) {
                if (value instanceof LocalDateTime) {
                    return Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant()).getTime();
                }
                if (value instanceof Date) {
                    return value;
                }
                return value;
            }
            DateTimeFormatter dateTimeFormatter = this.buildFormatter(format);
            if (value instanceof LocalDateTime) {
                return dateTimeFormatter.format((LocalDateTime)value);
            }
            if (value instanceof Date) {
                return dateTimeFormatter.format(LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()));
            }
            return value;
        });
        return field.transform(builder -> builder.argument(GraphQLArgument.newArgument().name("format").type((GraphQLInputType)Scalars.GraphQLString)).dataFetcher(dataFetcher));
    }

    private DateTimeFormatter buildFormatter(String format) {
        String dtFormat = format != null ? format : "YYYY-MM-dd'T'HH:mm:ss.SSS'Z'";
        return DateTimeFormatter.ofPattern(dtFormat);
    }
}

