/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.graphql.context;

import graphql.kickstart.execution.context.DefaultGraphQLContextBuilder;
import graphql.kickstart.execution.context.GraphQLContext;
import graphql.kickstart.servlet.context.GraphQLServletContextBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.transaction.Transactional;
import javax.websocket.Session;
import javax.websocket.server.HandshakeRequest;
import lombok.Generated;
import org.dataloader.DataLoader;
import org.dataloader.DataLoaderRegistry;
import org.jfantasy.framework.security.AuthenticationException;
import org.jfantasy.framework.security.AuthenticationManager;
import org.jfantasy.framework.security.SecurityContext;
import org.jfantasy.framework.security.SecurityContextHolder;
import org.jfantasy.framework.security.authentication.Authentication;
import org.jfantasy.framework.security.authentication.AuthenticationDetailsSource;
import org.jfantasy.framework.security.authentication.AuthenticationManagerResolver;
import org.jfantasy.framework.security.oauth2.server.BearerTokenAuthenticationToken;
import org.jfantasy.framework.security.oauth2.server.web.BearerTokenResolver;
import org.jfantasy.framework.security.oauth2.server.web.DefaultBearerTokenResolver;
import org.jfantasy.framework.security.web.WebAuthenticationDetailsSource;
import org.jfantasy.graphql.context.AuthorizationGraphQLServletContext;
import org.jfantasy.graphql.context.GraphQLContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.log.LogMessage;
import org.springframework.stereotype.Component;

@Component
public class SecurityGraphQLContextBuilder
extends DefaultGraphQLContextBuilder
implements GraphQLServletContextBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityGraphQLContextBuilder.class);
    private final BearerTokenResolver bearerTokenResolver = new DefaultBearerTokenResolver();
    private final AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    @Autowired
    private AuthenticationManagerResolver<HttpServletRequest> authenticationManagerResolver;

    @Transactional
    public GraphQLContext build(HttpServletRequest req, HttpServletResponse response) {
        GraphQLContextHolder.clear();
        SecurityContextHolder.clear();
        SecurityContext securityContext = SecurityContextHolder.createEmptyContext();
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        AuthorizationGraphQLServletContext context = new AuthorizationGraphQLServletContext(req, response, securityContext);
        context.setDataLoaderRegistry(this.buildDataLoaderRegistry());
        GraphQLContextHolder.setContext(context);
        String token = this.bearerTokenResolver.resolve(req);
        if (token == null) {
            log.trace("Did not process request since did not find bearer token");
            return context;
        }
        BearerTokenAuthenticationToken authenticationRequest = new BearerTokenAuthenticationToken(token);
        authenticationRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)req));
        try {
            AuthenticationManager authenticationManager = this.authenticationManagerResolver.resolve((Object)req);
            Authentication authenticationResult = authenticationManager.authenticate((Authentication)authenticationRequest);
            if (log.isDebugEnabled()) {
                log.debug(LogMessage.format((String)"Set SecurityContextHolder to %s", (Object)authenticationResult).toString());
            }
            context.setAuthentication(authenticationResult);
        }
        catch (AuthenticationException failed) {
            log.trace("Failed to process authentication request", (Throwable)failed);
        }
        return context;
    }

    public GraphQLContext build(Session session, HandshakeRequest request) {
        AuthorizationGraphQLServletContext context = new AuthorizationGraphQLServletContext(session, request);
        context.setDataLoaderRegistry(this.buildDataLoaderRegistry());
        return context;
    }

    private DataLoaderRegistry buildDataLoaderRegistry() {
        DataLoaderRegistry dataLoaderRegistry = new DataLoaderRegistry();
        dataLoaderRegistry.register("customerDataLoader", new DataLoader(customerIds -> CompletableFuture.supplyAsync(() -> {
            System.out.println(customerIds);
            return new ArrayList();
        })));
        return dataLoaderRegistry;
    }
}

