/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.autoconfigure;

import graphql.execution.ExecutionStrategy;
import graphql.execution.instrumentation.Instrumentation;
import graphql.kickstart.tools.SchemaParserDictionary;
import graphql.kickstart.tools.boot.GraphQLJavaToolsAutoConfiguration;
import java.util.List;
import org.aopalliance.aop.Advice;
import org.jfantasy.graphql.SchemaParserDictionaryBuilder;
import org.jfantasy.graphql.VersionGraphQLQueryResolver;
import org.jfantasy.graphql.client.GraphQLClientBeanPostProcessor;
import org.jfantasy.graphql.error.GraphQLResolverAdvice;
import org.jfantasy.graphql.error.GraphQLStaticMethodMatcherPointcut;
import org.jfantasy.graphql.execution.AsyncMutationExecutionStrategy;
import org.jfantasy.graphql.execution.AsyncQueryExecutionStrategy;
import org.jfantasy.graphql.execution.GraphQLTransactionInstrumentation;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.DefaultBeanFactoryPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.web.client.RestTemplate;

@Configuration
@AutoConfigureBefore(value={GraphQLJavaToolsAutoConfiguration.class})
@ComponentScan(value={"org.jfantasy.graphql.context", "org.jfantasy.graphql.error"})
public class GraphQLAutoConfiguration {
    @Bean
    static GraphQLClientBeanPostProcessor clientBeanPostProcessor(ApplicationContext applicationContext, ResourceLoader resourceLoader) {
        return new GraphQLClientBeanPostProcessor(applicationContext, resourceLoader);
    }

    @Bean(value={"queryExecutionStrategy"})
    public ExecutionStrategy queryExecutionStrategy() {
        return new AsyncQueryExecutionStrategy();
    }

    @Bean(value={"mutationExecutionStrategy"})
    public ExecutionStrategy mutationExecutionStrategy() {
        return new AsyncMutationExecutionStrategy();
    }

    @Bean
    public Instrumentation getInstrumentation(PlatformTransactionManager transactionManager) {
        return new GraphQLTransactionInstrumentation(transactionManager);
    }

    @Bean
    public SchemaParserDictionary schemaParserDictionary(List<SchemaParserDictionaryBuilder> builders) {
        SchemaParserDictionary dictionary = new SchemaParserDictionary();
        builders.forEach(item -> item.build(dictionary));
        return dictionary;
    }

    @Bean
    public DefaultBeanFactoryPointcutAdvisor graphQLErrorPointcutAdvisor(@Autowired GraphQLResolverAdvice advice) {
        DefaultBeanFactoryPointcutAdvisor beanFactory = new DefaultBeanFactoryPointcutAdvisor();
        beanFactory.setPointcut((Pointcut)new GraphQLStaticMethodMatcherPointcut());
        beanFactory.setAdvice((Advice)advice);
        return beanFactory;
    }

    @Bean
    public VersionGraphQLQueryResolver versionGraphQLQueryResolver() {
        return new VersionGraphQLQueryResolver();
    }

    @Bean
    public RestTemplate restTemplate() {
        RestTemplateBuilder builder = new RestTemplateBuilder(new RestTemplateCustomizer[0]);
        return builder.build();
    }
}

