/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.graphql.directives;

import graphql.Scalars;
import graphql.language.BooleanValue;
import graphql.language.StringValue;
import graphql.language.Value;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputType;
import graphql.schema.InputValueWithState;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.util.Objects;
import org.jfantasy.framework.util.common.file.FileUtil;

public class FileSizeDirective
implements SchemaDirectiveWiring {
    private static final String UNIT_NAME = "unit";
    private static final String FORMAT_NAME = "format";
    private static final GraphQLArgument.Builder FORMAT_ARGUMENT = GraphQLArgument.newArgument().name("format").defaultValueLiteral((Value)BooleanValue.of((boolean)false)).type((GraphQLInputType)Scalars.GraphQLBoolean).description("\u663e\u793a\u5355\u4f4d\uff0c \u6bd4\u5982\uff1a1024 => 1 KB");

    public GraphQLFieldDefinition onField(SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
        InputValueWithState unit = environment.getDirective().getArgument(UNIT_NAME).getArgumentValue();
        GraphQLFieldDefinition field = (GraphQLFieldDefinition)environment.getElement();
        GraphQLFieldsContainer parentType = environment.getFieldsContainer();
        DataFetcher originalDataFetcher = environment.getCodeRegistry().getDataFetcher(parentType, field);
        DataFetcher dataFetcher = DataFetcherFactories.wrapDataFetcher((DataFetcher)originalDataFetcher, (dataFetchingEnvironment, pValue) -> {
            Long value = (Long)pValue;
            Boolean format = (Boolean)dataFetchingEnvironment.getArgument(FORMAT_NAME);
            if (format == null || value == null || !format.booleanValue()) {
                return value;
            }
            return FileUtil.fileSize((long)FileUtil.fileSize((long)value, (String)((StringValue)Objects.requireNonNull(unit.getValue())).getValue()));
        });
        environment.getCodeRegistry().dataFetcher(parentType, field, dataFetcher);
        return field.transform(builder -> builder.argument(FORMAT_ARGUMENT));
    }
}

