/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.graphql.directives;

import graphql.Scalars;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetcherFactories;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputType;
import graphql.schema.idl.SchemaDirectiveWiring;
import graphql.schema.idl.SchemaDirectiveWiringEnvironment;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import org.jfantasy.framework.util.common.StringUtil;

public class DateFormatDirective
implements SchemaDirectiveWiring {
    private static final String FORMAT_NAME = "format";
    private static final GraphQLArgument.Builder FORMAT_ARGUMENT = GraphQLArgument.newArgument().name("format").type((GraphQLInputType)Scalars.GraphQLString).description("\u65e5\u671f\u683c\u5f0f, \u5982\uff1a YYYY-MM-dd");

    public GraphQLFieldDefinition onField(SchemaDirectiveWiringEnvironment<GraphQLFieldDefinition> environment) {
        GraphQLFieldDefinition field = (GraphQLFieldDefinition)environment.getElement();
        GraphQLFieldsContainer parentType = environment.getFieldsContainer();
        DataFetcher originalDataFetcher = environment.getCodeRegistry().getDataFetcher(parentType, field);
        DataFetcher dataFetcher = DataFetcherFactories.wrapDataFetcher((DataFetcher)originalDataFetcher, (dataFetchingEnvironment, value) -> {
            String format = (String)dataFetchingEnvironment.getArgument(FORMAT_NAME);
            if (StringUtil.isBlank((Object)format)) {
                if (value instanceof LocalDateTime) {
                    return Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant()).getTime();
                }
                if (value instanceof Date) {
                    return value;
                }
                return value;
            }
            DateTimeFormatter dateTimeFormatter = this.buildFormatter(format);
            if (value instanceof LocalDateTime) {
                return dateTimeFormatter.format((LocalDateTime)value);
            }
            if (value instanceof Date) {
                return dateTimeFormatter.format(LocalDateTime.ofInstant(((Date)value).toInstant(), ZoneId.systemDefault()));
            }
            return value;
        });
        environment.getCodeRegistry().dataFetcher(parentType, field, dataFetcher);
        return field.transform(builder -> builder.argument(FORMAT_ARGUMENT));
    }

    private DateTimeFormatter buildFormatter(String format) {
        String dtFormat = format != null ? format : "YYYY-MM-dd'T'HH:mm:ss.SSS'Z'";
        return DateTimeFormatter.ofPattern(dtFormat);
    }
}

