/*
 * Decompiled with CFR 0.152.
 */
package graphql.kickstart.spring.error;

import graphql.kickstart.execution.error.DefaultGraphQLErrorHandler;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import graphql.kickstart.spring.error.GraphQLErrorFactory;
import graphql.kickstart.spring.error.GraphQLErrorFromExceptionHandler;
import graphql.kickstart.spring.error.ReflectiveMethodValidator;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jfantasy.framework.util.common.ClassUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

public class GraphQLErrorHandlerFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLErrorHandlerFactory.class);

    public GraphQLErrorHandler create(ConfigurableApplicationContext applicationContext, boolean exceptionHandlersEnabled) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        List factories = Arrays.stream(beanFactory.getBeanDefinitionNames()).filter(arg_0 -> ((ConfigurableApplicationContext)applicationContext).containsBean(arg_0)).map(name -> this.scanForExceptionHandlers((ApplicationContext)applicationContext, (String)name)).flatMap(Collection::stream).collect(Collectors.toList());
        if (!factories.isEmpty() || exceptionHandlersEnabled) {
            log.debug("Handle GraphQL errors using exception handlers defined in {} custom factories", (Object)factories.size());
            return new GraphQLErrorFromExceptionHandler(factories);
        }
        log.debug("Using default GraphQL error handler");
        return new DefaultGraphQLErrorHandler();
    }

    private List<GraphQLErrorFactory> scanForExceptionHandlers(ApplicationContext context, String name) {
        try {
            Class objClz = context.getType(name);
            if (objClz == null) {
                log.info("Cannot load class " + name);
                return Collections.emptyList();
            }
            return Arrays.stream(ClassUtil.getRealClass((Class)objClz).getDeclaredMethods()).filter(ReflectiveMethodValidator::isGraphQLExceptionHandler).map(method -> GraphQLErrorFactory.withReflection((Object)context.getBean(name), (Method)method)).collect(Collectors.toList());
        }
        catch (BeanCreationException e) {
            log.error("Cannot load class {}. {}", (Object)name, (Object)e.getMessage());
            return Collections.emptyList();
        }
    }
}

