/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.graphql.scalars;

import graphql.language.IntValue;
import graphql.language.StringValue;
import graphql.scalars.ExtendedScalars;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import graphql.schema.GraphQLScalarType;
import java.util.Date;
import lombok.Generated;
import org.jfantasy.framework.dao.hibernate.util.ReflectionUtils;
import org.jfantasy.framework.util.common.DateUtil;
import org.jfantasy.graphql.DateBetween;
import org.jfantasy.graphql.scalars.OrderCoercing;
import org.jfantasy.graphql.util.Kit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;

public class GraphQLScalarTypeConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GraphQLScalarTypeConfiguration.class);

    @Bean
    public GraphQLScalarType jsonScalar() {
        return ExtendedScalars.Json;
    }

    @Bean
    public GraphQLScalarType orderByScalar() {
        return GraphQLScalarType.newScalar().name("OrderBy").description("\u6392\u5e8f\u5bf9\u8c61, \u683c\u5f0f\u5982\uff1acreatedAt_ASC ").coercing((Coercing)new OrderCoercing()).build();
    }

    @Bean
    public GraphQLScalarType dateScalar() {
        return GraphQLScalarType.newScalar().name("Date").description(" Date \u8f6c\u6362\u7c7b").coercing((Coercing)new Coercing<Date, Object>(){

            public Object serialize(Object input) throws CoercingSerializeException {
                if (input instanceof Date) {
                    return ((Date)input).getTime();
                }
                return input;
            }

            public Date parseValue(Object input) throws CoercingParseValueException {
                if (input instanceof Date) {
                    return (Date)input;
                }
                if (!(input instanceof String)) {
                    throw new CoercingParseValueException("Expected a 'String' or 'java.time.temporal.TemporalAccessor' but was '" + Kit.typeName(input) + "'.");
                }
                return (Date)ReflectionUtils.convert((Object)input, Date.class);
            }

            public Date parseLiteral(Object input) throws CoercingParseLiteralException {
                if (input instanceof StringValue) {
                    return (Date)ReflectionUtils.convert((Object)((StringValue)input).getValue(), Date.class);
                }
                if (input instanceof IntValue) {
                    return new Date(((IntValue)input).getValue().longValue());
                }
                return null;
            }
        }).build();
    }

    @Bean
    public GraphQLScalarType dateBetweenScalar() {
        return GraphQLScalarType.newScalar().name("DateBetween").description("\u65f6\u95f4\u533a\u95f4\u53c2\u6570").coercing((Coercing)new Coercing<DateBetween, String>(){

            public String serialize(Object input) throws CoercingSerializeException {
                return input.toString();
            }

            public DateBetween parseValue(Object input) throws CoercingParseValueException {
                if (!input.toString().contains(",")) {
                    return null;
                }
                String[] inputs = input.toString().split(",");
                return DateBetween.newDateBetween(DateUtil.parseFormat((String)inputs[0]), DateUtil.parseFormat((String)inputs[1]));
            }

            public DateBetween parseLiteral(Object input) throws CoercingParseLiteralException {
                if (!(input instanceof StringValue)) {
                    throw new CoercingParseLiteralException("Expected AST type 'StringValue' but was '" + Kit.typeName(input) + "'.");
                }
                return this.parseValue(((StringValue)input).getValue());
            }
        }).build();
    }
}

