/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.graphql.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jfantasy.framework.util.common.StringUtil;
import org.jfantasy.graphql.client.GraphQLClient;
import org.jfantasy.graphql.client.GraphQLTemplate;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.client.RestTemplate;

public class GraphQLClientBeanPostProcessor
implements BeanPostProcessor {
    private final ResourceLoader resourceLoader;
    private final ApplicationContext applicationContext;
    private Map<String, GraphQLTemplate> clientMap = new HashMap<String, GraphQLTemplate>();

    public GraphQLClientBeanPostProcessor(ApplicationContext applicationContext, ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
        this.applicationContext = Objects.requireNonNull(applicationContext, "applicationContext");
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        Class<?> clazz = bean.getClass();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                GraphQLClient annotation = (GraphQLClient)AnnotationUtils.findAnnotation((AnnotatedElement)field, GraphQLClient.class);
                if (annotation == null) continue;
                ReflectionUtils.makeAccessible((Field)field);
                ReflectionUtils.setField((Field)field, (Object)bean, this.processInjectionPoint(field, field.getType(), annotation));
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return bean;
    }

    protected <T> T processInjectionPoint(Member injectionTarget, Class<T> injectionType, GraphQLClient annotation) {
        String name = annotation.value();
        T value = this.valueForMember(name, injectionTarget, injectionType);
        if (value == null) {
            throw new IllegalStateException("Injection value is null unexpectedly for " + name + " at " + injectionTarget);
        }
        return value;
    }

    protected <T> T valueForMember(String name, Member injectionTarget, Class<T> injectionType) throws BeansException {
        if (this.clientMap.containsKey(name)) {
            return (T)this.clientMap.get(name);
        }
        Environment environment = this.applicationContext.getEnvironment();
        String url = environment.getProperty("graphql.client." + name + ".address");
        if (StringUtil.isBlank((Object)url) || !GraphQLTemplate.class.isAssignableFrom(injectionType)) {
            throw new BeanInstantiationException(injectionType, "Failed to create GraphQL Client of Name " + name);
        }
        GraphQLTemplate graphQLTemplate = this.createGraphQLTemplate(url);
        this.clientMap.put(name, graphQLTemplate);
        return (T)graphQLTemplate;
    }

    public GraphQLTemplate createGraphQLTemplate(String url) {
        RestTemplate restTemplate = (RestTemplate)this.applicationContext.getBean(RestTemplate.class);
        ObjectMapper objectMapper = (ObjectMapper)this.applicationContext.getBean(ObjectMapper.class);
        return new GraphQLTemplate(this.resourceLoader, restTemplate, url, objectMapper);
    }
}

