/*
 * Decompiled with CFR 0.152.
 */
package org.jfantasy.graphql.error;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.aspectj.lang.annotation.Aspect;
import org.jfantasy.framework.util.common.ClassUtil;
import org.springframework.aop.MethodBeforeAdvice;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.validation.DataBinder;
import org.springframework.validation.SmartValidator;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.MethodArgumentNotValidException;

@Aspect
@Component
public class GraphQLResolverAdvice
implements MethodBeforeAdvice {
    @Autowired
    private SmartValidator validator;

    public final DataBinder createBinder(Object target, String objectName) {
        DataBinder binder = new DataBinder(target, objectName);
        binder.setValidator((Validator)this.validator);
        return binder;
    }

    protected void validateIfApplicable(DataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            binder.validate(validationHints);
            break;
        }
    }

    public void before(Method method, Object[] args, Object target) throws Throwable {
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            MethodParameter parameter = MethodParameter.forParameter((Parameter)parameters[i]);
            DataBinder binder = this.createBinder(args[i], ClassUtil.getParameterName((Parameter)parameters[i]));
            this.validateIfApplicable(binder, parameter);
            if (!binder.getBindingResult().hasErrors()) continue;
            throw new MethodArgumentNotValidException(parameter, binder.getBindingResult());
        }
    }
}

