/*
 * Decompiled with CFR 0.152.
 */
package cn.arnohand;

import cn.arnohand.MyPutRet;
import cn.arnohand.QiNiuConfigModule;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.UpCompletionHandler;
import com.qiniu.storage.UploadManager;
import com.qiniu.storage.model.FileInfo;
import com.qiniu.util.Auth;
import com.qiniu.util.Md5;
import com.qiniu.util.StringMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class QiNiuUtil {
    public static MyPutRet upload(String localFilePath, QiNiuConfigModule module) throws Exception {
        return QiNiuUtil.upload(localFilePath, null, null, null, module);
    }

    public static MyPutRet upload(String localFilePath, String key, QiNiuConfigModule module) throws Exception {
        return QiNiuUtil.upload(localFilePath, key, null, null, module);
    }

    public static MyPutRet upload(String localFilePath, String key, StringMap params, String fileType, QiNiuConfigModule module) throws Exception {
        File file = FileUtil.file((String)localFilePath);
        if (!file.exists()) {
            throw new FileNotFoundException("file not found: " + localFilePath);
        }
        if (StrUtil.isEmpty((CharSequence)key)) {
            key = Md5.md5((File)file);
        }
        String upToken = module.getUpToken();
        UploadManager uploadManager = module.getUploadManager();
        Response response = uploadManager.put(file, key, upToken, params, fileType, false);
        return (MyPutRet)JSON.parseObject((String)response.bodyString(), MyPutRet.class);
    }

    public static void asyncUpload(String localFilePath, UpCompletionHandler handler, QiNiuConfigModule module) throws Exception {
        QiNiuUtil.asyncUpload(localFilePath, null, handler, module);
    }

    public static void asyncUpload(String localFilePath, String key, UpCompletionHandler handler, QiNiuConfigModule module) throws Exception {
        QiNiuUtil.asyncUpload(localFilePath, key, null, null, handler, module);
    }

    public static void asyncUpload(String localFilePath, String key, StringMap params, String fileType, UpCompletionHandler handler, QiNiuConfigModule module) throws Exception {
        File file = FileUtil.file((String)localFilePath);
        if (!file.exists()) {
            throw new FileNotFoundException("file not found: " + localFilePath);
        }
        if (StrUtil.isEmpty((CharSequence)key)) {
            key = Md5.md5((File)file);
        }
        UploadManager uploadManager = module.getUploadManager();
        byte[] bytes = IoUtil.readBytes((InputStream)FileUtil.getInputStream((File)file));
        uploadManager.asyncPut(bytes, key, module.getUpToken(), params, fileType, false, handler);
    }

    public static FileInfo state(String key, QiNiuConfigModule module) {
        try {
            BucketManager bucketManager = module.getBucketManager();
            return bucketManager.stat(module.getBucket(), key);
        }
        catch (QiniuException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getPrivateDownloadUrl(String url, QiNiuConfigModule module) {
        Auth auth = module.getAuth();
        return auth.privateDownloadUrl(url);
    }

    public static boolean delete(String key, QiNiuConfigModule module) throws Exception {
        BucketManager bucketManager = module.getBucketManager();
        Response delete = bucketManager.delete(module.getBucket(), key);
        return delete.statusCode == 200;
    }
}

