package cn.arnohand;

import cn.hutool.core.util.StrUtil;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import com.qiniu.util.StringMap;

public class QiNiuConfigModule {
    private String accessKey;
    /**
     * 签名密钥
     */
    private String secretKey;
    /**
     * 空间名称
     */
    private String bucket;

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getBucket() {
        return bucket;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public UploadManager getUploadManager() {
        return new UploadManager(new Configuration());
    }

    public BucketManager getBucketManager() {
        return new BucketManager(getAuth(), new Configuration());
    }

    /**
     * 简单上传的凭证
     */
    public String getUpToken() {
        return getUpToken(bucket);
    }

    /**
     * 简单上传的凭证
     */
    public String getUpToken(String bucket) {
        if (StrUtil.isEmpty(bucket)) {
            throw new IllegalArgumentException("please set QiNiu BUCKET");
        }
        Auth auth = getAuth();
        StringMap putPolicy = new StringMap();
        putPolicy.put("returnBody", "{\"key\":\"$(key)\",\"hash\":\"$(etag)\",\"bucket\":\"$(bucket)\",\"fSize\":$(fsize)}");
        long expireSeconds = 3600;
        return auth.uploadToken(bucket, null, expireSeconds, putPolicy);
    }

    /**
     * 上传策略
     */
    public Auth getAuth() {
        if (StrUtil.isEmpty(accessKey)) {
            throw new IllegalArgumentException("please set QiNiu ACCESS_KEY");
        }
        if (StrUtil.isEmpty(secretKey)) {
            throw new IllegalArgumentException("please set QiNiu SECRET_KEY");
        }
        return Auth.create(accessKey, secretKey);
    }
}
