/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.base.Function;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.mapstruct.Mapper;
import springfox.documentation.service.ListVendorExtension;
import springfox.documentation.service.ObjectVendorExtension;
import springfox.documentation.service.StringVendorExtension;
import springfox.documentation.service.VendorExtension;

@Mapper(componentModel="spring")
public class VendorExtensionsMapper {
    public Map<String, Object> mapExtensions(List<VendorExtension> from) {
        TreeMap extensions = Maps.newTreeMap();
        FluentIterable listExtensions = FluentIterable.from(from).filter(ListVendorExtension.class);
        for (Object each : listExtensions) {
            extensions.put(each.getName(), each.getValue());
        }
        FluentIterable objectExtensions = FluentIterable.from(from).filter(ObjectVendorExtension.class).transform(this.toExtensionMap());
        for (Map each : objectExtensions) {
            extensions.putAll(each);
        }
        FluentIterable propertyExtensions = FluentIterable.from(from).filter(StringVendorExtension.class);
        for (StringVendorExtension each : propertyExtensions) {
            extensions.put(each.getName(), each.getValue());
        }
        return extensions;
    }

    private Function<ObjectVendorExtension, Map<String, Object>> toExtensionMap() {
        return new Function<ObjectVendorExtension, Map<String, Object>>(){

            public Map<String, Object> apply(ObjectVendorExtension input) {
                if (!Strings.isNullOrEmpty((String)input.getName())) {
                    HashMap map = Maps.newHashMap();
                    map.put(input.getName(), VendorExtensionsMapper.this.mapExtensions(input.getValue()));
                    return map;
                }
                return VendorExtensionsMapper.this.propertiesAsMap(input);
            }
        };
    }

    private Map<String, Object> propertiesAsMap(ObjectVendorExtension input) {
        HashMap properties = Maps.newHashMap();
        FluentIterable stringExtensions = FluentIterable.from((Iterable)input.getValue()).filter(StringVendorExtension.class);
        for (StringVendorExtension property : stringExtensions) {
            properties.put(property.getName(), property.getValue());
        }
        FluentIterable objectExtensions = FluentIterable.from((Iterable)input.getValue()).filter(ObjectVendorExtension.class);
        for (ObjectVendorExtension property : objectExtensions) {
            properties.put(property.getName(), this.mapExtensions(property.getValue()));
        }
        return properties;
    }
}

