/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger2.mappers;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.Map;
import java.util.TreeMap;
import org.mapstruct.Mapper;
import springfox.documentation.service.ResourceListing;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.swagger2.mappers.ApiKeyAuthFactory;
import springfox.documentation.swagger2.mappers.BasicAuthFactory;
import springfox.documentation.swagger2.mappers.OAuth2AuthFactory;
import springfox.documentation.swagger2.mappers.SecuritySchemeFactory;

@Mapper(componentModel="spring")
public class SecurityMapper {
    private Map<String, SecuritySchemeFactory> factories = ImmutableMap.builder().put((Object)"oauth2", (Object)new OAuth2AuthFactory()).put((Object)"apiKey", (Object)new ApiKeyAuthFactory()).put((Object)"basicAuth", (Object)new BasicAuthFactory()).build();

    public Map<String, SecuritySchemeDefinition> toSecuritySchemeDefinitions(ResourceListing from) {
        if (from == null) {
            return Maps.newHashMap();
        }
        TreeMap result = Maps.newTreeMap();
        result.putAll(Maps.transformValues((Map)Maps.uniqueIndex((Iterable)from.getSecuritySchemes(), this.schemeName()), this.toSecuritySchemeDefinition()));
        return result;
    }

    private Function<SecurityScheme, String> schemeName() {
        return new Function<SecurityScheme, String>(){

            public String apply(SecurityScheme input) {
                return input.getName();
            }
        };
    }

    private Function<SecurityScheme, SecuritySchemeDefinition> toSecuritySchemeDefinition() {
        return new Function<SecurityScheme, SecuritySchemeDefinition>(){

            public SecuritySchemeDefinition apply(SecurityScheme input) {
                return SecurityMapper.this.factories.get(input.getType()).create(input);
            }
        };
    }
}

