/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.schema.property;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.classmate.members.ResolvedParameterizedMember;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ModelPropertyBuilder;
import springfox.documentation.schema.Annotations;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.ResolvedTypes;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.schema.configuration.ObjectMapperConfigured;
import springfox.documentation.schema.plugins.SchemaPluginsManager;
import springfox.documentation.schema.property.BeanPropertyDefinitions;
import springfox.documentation.schema.property.BeanPropertyNamingStrategy;
import springfox.documentation.schema.property.FactoryMethodProvider;
import springfox.documentation.schema.property.ModelPropertiesProvider;
import springfox.documentation.schema.property.SimpleMethodSignatureEquality;
import springfox.documentation.schema.property.bean.AccessorsProvider;
import springfox.documentation.schema.property.bean.BeanModelProperty;
import springfox.documentation.schema.property.bean.ParameterModelProperty;
import springfox.documentation.schema.property.field.FieldModelProperty;
import springfox.documentation.schema.property.field.FieldProvider;
import springfox.documentation.spi.schema.contexts.ModelContext;
import springfox.documentation.spi.schema.contexts.ModelPropertyContext;

@Primary
@Component(value="optimized")
public class OptimizedModelPropertiesProvider
implements ModelPropertiesProvider {
    private static final Logger LOG = LoggerFactory.getLogger(OptimizedModelPropertiesProvider.class);
    private final AccessorsProvider accessors;
    private final FieldProvider fields;
    private final FactoryMethodProvider factoryMethods;
    private final TypeResolver typeResolver;
    private final BeanPropertyNamingStrategy namingStrategy;
    private final SchemaPluginsManager schemaPluginsManager;
    private final TypeNameExtractor typeNameExtractor;
    private ObjectMapper objectMapper;

    @Autowired
    public OptimizedModelPropertiesProvider(AccessorsProvider accessors, FieldProvider fields, FactoryMethodProvider factoryMethods, TypeResolver typeResolver, BeanPropertyNamingStrategy namingStrategy, SchemaPluginsManager schemaPluginsManager, TypeNameExtractor typeNameExtractor) {
        this.accessors = accessors;
        this.fields = fields;
        this.factoryMethods = factoryMethods;
        this.typeResolver = typeResolver;
        this.namingStrategy = namingStrategy;
        this.schemaPluginsManager = schemaPluginsManager;
        this.typeNameExtractor = typeNameExtractor;
    }

    public void onApplicationEvent(ObjectMapperConfigured event) {
        this.objectMapper = event.getObjectMapper();
    }

    @Override
    public List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext) {
        List<ModelProperty> syntheticProperties = this.schemaPluginsManager.syntheticProperties(givenContext);
        if (!syntheticProperties.isEmpty()) {
            return syntheticProperties;
        }
        return this.propertiesFor(type, givenContext, "");
    }

    private List<ModelProperty> propertiesFor(ResolvedType type, ModelContext givenContext, String namePrefix) {
        ArrayList properties = Lists.newArrayList();
        BeanDescription beanDescription = this.beanDescription(type, givenContext);
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), BeanPropertyDefinitions.beanPropertyByInternalName());
        for (Map.Entry each : propertyLookup.entrySet()) {
            LOG.debug("Reading property {}", each.getKey());
            BeanPropertyDefinition jacksonProperty = (BeanPropertyDefinition)each.getValue();
            Optional annotatedMember = Optional.fromNullable((Object)this.safeGetPrimaryMember(jacksonProperty));
            if (!annotatedMember.isPresent()) continue;
            properties.addAll(this.candidateProperties(type, (AnnotatedMember)annotatedMember.get(), jacksonProperty, givenContext, namePrefix));
        }
        return FluentIterable.from((Iterable)properties).toSortedSet(this.byPropertyName()).asList();
    }

    private Comparator<ModelProperty> byPropertyName() {
        return new Comparator<ModelProperty>(){

            @Override
            public int compare(ModelProperty first, ModelProperty second) {
                return first.getName().compareTo(second.getName());
            }
        };
    }

    private AnnotatedMember safeGetPrimaryMember(BeanPropertyDefinition jacksonProperty) {
        try {
            return jacksonProperty.getPrimaryMember();
        }
        catch (IllegalArgumentException e) {
            LOG.warn(String.format("Unable to get unique property. %s", e.getMessage()));
            return null;
        }
    }

    private Function<ResolvedMethod, List<ModelProperty>> propertyFromBean(final ModelContext givenContext, final BeanPropertyDefinition jacksonProperty, final String namePrefix) {
        return new Function<ResolvedMethod, List<ModelProperty>>(){

            public List<ModelProperty> apply(ResolvedMethod input) {
                ResolvedType type = BeanModelProperty.paramOrReturnType(OptimizedModelPropertiesProvider.this.typeResolver, input);
                if (!givenContext.canIgnore(type)) {
                    if (Annotations.memberIsUnwrapped(jacksonProperty.getPrimaryMember())) {
                        return OptimizedModelPropertiesProvider.this.propertiesFor(type, ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)type), String.format("%s%s", namePrefix, Annotations.unwrappedPrefix(jacksonProperty.getPrimaryMember())));
                    }
                    return Lists.newArrayList((Object[])new ModelProperty[]{OptimizedModelPropertiesProvider.this.beanModelProperty(input, jacksonProperty, givenContext, namePrefix)});
                }
                return Lists.newArrayList();
            }
        };
    }

    private Function<ResolvedField, List<ModelProperty>> propertyFromField(final ModelContext givenContext, final BeanPropertyDefinition jacksonProperty, final String namePrefix) {
        return new Function<ResolvedField, List<ModelProperty>>(){

            public List<ModelProperty> apply(ResolvedField input) {
                if (!givenContext.canIgnore(input.getType())) {
                    if (Annotations.memberIsUnwrapped((AnnotatedMember)jacksonProperty.getField())) {
                        return OptimizedModelPropertiesProvider.this.propertiesFor(input.getType(), ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)input.getType()), String.format("%s%s", namePrefix, Annotations.unwrappedPrefix(jacksonProperty.getPrimaryMember())));
                    }
                    return Lists.newArrayList((Object[])new ModelProperty[]{OptimizedModelPropertiesProvider.this.fieldModelProperty(input, jacksonProperty, givenContext, namePrefix)});
                }
                return Lists.newArrayList();
            }
        };
    }

    private List<ModelProperty> candidateProperties(ResolvedType type, AnnotatedMember member, BeanPropertyDefinition jacksonProperty, ModelContext givenContext, String namePrefix) {
        ArrayList properties = Lists.newArrayList();
        if (member instanceof AnnotatedMethod) {
            properties.addAll((Collection)this.findAccessorMethod(type, member).transform(this.propertyFromBean(givenContext, jacksonProperty, namePrefix)).or(new ArrayList()));
        } else if (member instanceof AnnotatedField) {
            properties.addAll((Collection)this.findField(type, jacksonProperty.getInternalName()).transform(this.propertyFromField(givenContext, jacksonProperty, namePrefix)).or(new ArrayList()));
        } else if (member instanceof AnnotatedParameter) {
            ModelContext modelContext = ModelContext.fromParent((ModelContext)givenContext, (ResolvedType)type);
            properties.addAll(this.fromFactoryMethod(type, jacksonProperty, (AnnotatedParameter)member, modelContext, namePrefix));
        }
        return FluentIterable.from((Iterable)properties).filter(this.hiddenProperties()).toList();
    }

    private Predicate<? super ModelProperty> hiddenProperties() {
        return new Predicate<ModelProperty>(){

            public boolean apply(ModelProperty input) {
                return !input.isHidden();
            }
        };
    }

    private Optional<ResolvedField> findField(ResolvedType resolvedType, final String fieldName) {
        return Iterables.tryFind(this.fields.in(resolvedType), (Predicate)new Predicate<ResolvedField>(){

            public boolean apply(ResolvedField input) {
                return fieldName.equals(input.getName());
            }
        });
    }

    private ModelProperty fieldModelProperty(ResolvedField childField, BeanPropertyDefinition jacksonProperty, ModelContext modelContext, String namePrefix) {
        String fieldName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy, namePrefix);
        FieldModelProperty fieldModelProperty = new FieldModelProperty(fieldName, childField, this.typeResolver, modelContext.getAlternateTypeProvider(), jacksonProperty);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(fieldModelProperty.getName()).type(fieldModelProperty.getType()).qualifiedType(fieldModelProperty.qualifiedTypeName()).position(fieldModelProperty.position()).required(Boolean.valueOf(fieldModelProperty.isRequired())).description(fieldModelProperty.propertyDescription()).allowableValues(fieldModelProperty.allowableValues()).example(fieldModelProperty.example());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, (AnnotatedElement)((Object)childField.getRawMember()), this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor));
    }

    private ModelProperty beanModelProperty(ResolvedMethod childProperty, BeanPropertyDefinition jacksonProperty, ModelContext modelContext, String namePrefix) {
        String propertyName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy, namePrefix);
        BeanModelProperty beanModelProperty = new BeanModelProperty(propertyName, childProperty, this.typeResolver, modelContext.getAlternateTypeProvider(), jacksonProperty);
        LOG.debug("Adding property {} to model", (Object)propertyName);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(beanModelProperty.getName()).type(beanModelProperty.getType()).qualifiedType(beanModelProperty.qualifiedTypeName()).position(beanModelProperty.position()).required(Boolean.valueOf(beanModelProperty.isRequired())).isHidden(Boolean.valueOf(false)).description(beanModelProperty.propertyDescription()).allowableValues(beanModelProperty.allowableValues()).example(beanModelProperty.example());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, jacksonProperty, this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor));
    }

    private ModelProperty paramModelProperty(ResolvedParameterizedMember constructor, BeanPropertyDefinition jacksonProperty, AnnotatedParameter parameter, ModelContext modelContext, String namePrefix) {
        String propertyName = BeanPropertyDefinitions.name(jacksonProperty, modelContext.isReturnType(), this.namingStrategy, namePrefix);
        ParameterModelProperty parameterModelProperty = new ParameterModelProperty(propertyName, parameter, constructor, this.typeResolver, modelContext.getAlternateTypeProvider(), jacksonProperty);
        LOG.debug("Adding property {} to model", (Object)propertyName);
        ModelPropertyBuilder propertyBuilder = new ModelPropertyBuilder().name(parameterModelProperty.getName()).type(parameterModelProperty.getType()).qualifiedType(parameterModelProperty.qualifiedTypeName()).position(parameterModelProperty.position()).required(Boolean.valueOf(parameterModelProperty.isRequired())).isHidden(Boolean.valueOf(false)).description(parameterModelProperty.propertyDescription()).allowableValues(parameterModelProperty.allowableValues()).example(parameterModelProperty.example());
        return this.schemaPluginsManager.property(new ModelPropertyContext(propertyBuilder, jacksonProperty, this.typeResolver, modelContext.getDocumentationType())).updateModelRef(ResolvedTypes.modelRefFactory(modelContext, this.typeNameExtractor));
    }

    private Optional<ResolvedMethod> findAccessorMethod(ResolvedType resolvedType, final AnnotatedMember member) {
        return Iterables.tryFind(this.accessors.in(resolvedType), (Predicate)new Predicate<ResolvedMethod>(){

            public boolean apply(ResolvedMethod accessorMethod) {
                SimpleMethodSignatureEquality methodComparer = new SimpleMethodSignatureEquality();
                return methodComparer.equivalent((Method)accessorMethod.getRawMember(), (Method)member.getMember());
            }
        });
    }

    private List<ModelProperty> fromFactoryMethod(ResolvedType resolvedType, final BeanPropertyDefinition beanProperty, final AnnotatedParameter member, final ModelContext givenContext, final String namePrefix) {
        Optional property = this.factoryMethods.in(resolvedType, FactoryMethodProvider.factoryMethodOf(member)).transform((Function)new Function<ResolvedParameterizedMember, ModelProperty>(){

            public ModelProperty apply(ResolvedParameterizedMember input) {
                return OptimizedModelPropertiesProvider.this.paramModelProperty(input, beanProperty, member, givenContext, namePrefix);
            }
        });
        if (property.isPresent()) {
            return Lists.newArrayList((Object[])new ModelProperty[]{(ModelProperty)property.get()});
        }
        return Lists.newArrayList();
    }

    private BeanDescription beanDescription(ResolvedType type, ModelContext context) {
        if (context.isReturnType()) {
            SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
            return serializationConfig.introspect(serializationConfig.constructType(type.getErasedType()));
        }
        DeserializationConfig serializationConfig = this.objectMapper.getDeserializationConfig();
        return serializationConfig.introspect(serializationConfig.constructType(type.getErasedType()));
    }
}

