/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.zookeeper.boot.starter.support;

import cn.aradin.spring.core.thread.AradinExecutors;
import cn.aradin.zookeeper.boot.starter.handler.INodeHandler;
import cn.aradin.zookeeper.boot.starter.manager.ZookeeperClientManager;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;

public class ZookeeperEventDispatcher
implements PathChildrenCacheListener {
    private List<INodeHandler> nodeHandlers;

    public ZookeeperEventDispatcher(List<INodeHandler> nodeHandlers) {
        this.nodeHandlers = nodeHandlers;
    }

    public void initHandlers(ZookeeperClientManager clientManager) {
        this.nodeHandlers.forEach(handler -> handler.init(clientManager));
    }

    public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
        if (CollectionUtils.isNotEmpty(this.nodeHandlers)) {
            this.nodeHandlers.forEach(nodeHandler -> {
                if (nodeHandler.support(event)) {
                    CompletableFuture.runAsync(new Runnable((INodeHandler)nodeHandler, client, event){
                        final /* synthetic */ INodeHandler val$nodeHandler;
                        final /* synthetic */ CuratorFramework val$client;
                        final /* synthetic */ PathChildrenCacheEvent val$event;
                        {
                            this.val$nodeHandler = iNodeHandler;
                            this.val$client = curatorFramework;
                            this.val$event = pathChildrenCacheEvent;
                        }

                        @Override
                        public void run() {
                            this.val$nodeHandler.handler(this.val$client, this.val$event);
                        }
                    }, AradinExecutors.newFixedThreadPool((String)"zookeeperevent", (int)4, (int)8, (int)10000, (long)2000L));
                }
            });
        }
    }
}

