/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.zookeeper.boot.starter.manager;

import cn.aradin.zookeeper.boot.starter.properties.Zookeeper;
import cn.aradin.zookeeper.boot.starter.properties.ZookeeperProperties;
import cn.aradin.zookeeper.boot.starter.support.ZookeeperEventDispatcher;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.retry.ExponentialBackoffRetry;

public class ZookeeperClientManager {
    private ZookeeperProperties zookeeperProperties;
    private ZookeeperEventDispatcher dispatcher;
    private Map<String, CuratorFramework> zookeeperClients = new ConcurrentHashMap<String, CuratorFramework>(15);

    public ZookeeperClientManager(ZookeeperProperties zookeeperProperties, ZookeeperEventDispatcher dispatcher) {
        this.zookeeperProperties = zookeeperProperties;
        this.dispatcher = dispatcher;
    }

    @PostConstruct
    public void init() {
        if (this.zookeeperProperties.isEnable() && CollectionUtils.isNotEmpty(this.zookeeperProperties.getAddresses())) {
            ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(1000, 3);
            this.zookeeperProperties.getAddresses().forEach(arg_0 -> this.lambda$init$0((RetryPolicy)retryPolicy, arg_0));
            this.dispatcher.initHandlers(this);
        }
    }

    public CuratorFramework getClient(String id) {
        Optional<Zookeeper> result = this.zookeeperProperties.getAddresses().stream().filter(zookeeper -> zookeeper.getId().equals(id)).findAny();
        if (result.isPresent()) {
            return this.zookeeperClients.get(result.get().getAddress());
        }
        throw new NullPointerException("Client " + id + " Not Exist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$init$0(RetryPolicy retryPolicy, Zookeeper address) {
        CuratorFramework client = this.zookeeperClients.get(address.getAddress());
        if (client == null) {
            String string = address.getAddress().intern();
            synchronized (string) {
                try {
                    client = this.zookeeperClients.get(address.getAddress());
                    if (client == null) {
                        client = CuratorFrameworkFactory.builder().connectString(address.getAddress()).sessionTimeoutMs(this.zookeeperProperties.getSessionTimeout()).connectionTimeoutMs(this.zookeeperProperties.getConnectionTimeout()).retryPolicy(retryPolicy).build();
                        this.zookeeperClients.put(address.getAddress(), client);
                        client.start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getCause());
                }
            }
        }
        try {
            client.createContainers(address.getId());
            PathChildrenCache childrenCache = new PathChildrenCache(client, "/" + address.getId(), true);
            childrenCache.getListenable().addListener((Object)this.dispatcher);
            childrenCache.start(PathChildrenCache.StartMode.POST_INITIALIZED_EVENT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

