/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.version.zookeeper.starter.handler;

import cn.aradin.version.core.dispatcher.VersionDispatcher;
import cn.aradin.version.core.properties.VersionProperties;
import cn.aradin.zookeeper.boot.starter.handler.INodeHandler;
import cn.aradin.zookeeper.boot.starter.manager.ZookeeperClientManager;
import cn.aradin.zookeeper.boot.starter.properties.Zookeeper;
import cn.aradin.zookeeper.boot.starter.properties.ZookeeperProperties;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.state.ConnectionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionsNodeHandler
implements INodeHandler {
    private static final Logger log = LoggerFactory.getLogger(VersionsNodeHandler.class);
    private VersionProperties versionProperties;
    private VersionDispatcher versionDispatcher;
    private CuratorFramework zookeeperClient;

    public VersionsNodeHandler(VersionProperties versionProperties, ZookeeperProperties zookeeperProperties, VersionDispatcher versionDispatcher) {
        Optional<Zookeeper> result;
        if (versionProperties == null) {
            throw new RuntimeException("Version is not config");
        }
        this.versionProperties = versionProperties;
        this.versionDispatcher = versionDispatcher;
        if (zookeeperProperties != null && versionProperties != null && CollectionUtils.isNotEmpty((Collection)zookeeperProperties.getAddresses()) && versionProperties.getZookeeper() != null && !(result = zookeeperProperties.getAddresses().stream().filter(zookeeper -> zookeeper.getId().equals(versionProperties.getZookeeper().getAddressId())).findAny()).isPresent()) {
            return;
        }
        throw new RuntimeException("Version's Zookeeper is not config");
    }

    public void init(ZookeeperClientManager clientManager) {
        this.zookeeperClient = clientManager.getClient(this.versionProperties.getZookeeper().getAddressId());
        if (this.zookeeperClient == null) {
            throw new RuntimeException("Version's Zookeeper Client is not exist, Please check the sync-type");
        }
        this.zookeeperClient.getConnectionStateListenable().addListener((Object)this);
    }

    public boolean support(PathChildrenCacheEvent event) {
        if (log.isDebugEnabled()) {
            log.debug("Received Event {}", (Object)event.getType());
        }
        String path = event.getData().getPath();
        if (log.isDebugEnabled()) {
            log.debug("Received Event Path {} {}", (Object)path, (Object)event.getType());
        }
        if ((path = path.substring(0, path.lastIndexOf("/"))).contains("/") && (path = path.substring(0, path.lastIndexOf("/"))).contains("/")) {
            String versions = path.substring(path.lastIndexOf("/") + 1);
            if (this.versionProperties.getZookeeper().getAddressId().equalsIgnoreCase(versions)) {
                return true;
            }
        }
        return false;
    }

    public void handler(CuratorFramework client, PathChildrenCacheEvent event) {
        switch (event.getType()) {
            case CHILD_UPDATED: {
                String path = event.getData().getPath();
                String key = path.substring(path.lastIndexOf("/") + 1);
                path = path.substring(0, path.lastIndexOf("/"));
                String group = path.substring(path.lastIndexOf("/") + 1);
                this.versionDispatcher.dispatchVersion(group, key, String.valueOf(event.getData().getData()));
                break;
            }
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        log.warn("Zookeeper Version Connect Status Changed {}", (Object)newState.name());
    }
}

