/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.version.zookeeper.starter.handler;

import cn.aradin.spring.core.bean.AradinBeanFactory;
import cn.aradin.version.core.gentor.IVersionGentor;
import cn.aradin.version.core.handler.IVersionBroadHandler;
import cn.aradin.version.core.properties.VersionProperties;
import cn.aradin.zookeeper.boot.starter.manager.ZookeeperClientManager;
import java.nio.charset.Charset;
import org.apache.curator.framework.CuratorFramework;

public class VersionZookeeperBroadHandler
implements IVersionBroadHandler {
    private VersionProperties versionProperties;
    private IVersionGentor versionGentor;
    private CuratorFramework zookeeperClient;

    public VersionZookeeperBroadHandler(VersionProperties versionProperties, IVersionGentor versionGentor) {
        this.versionProperties = versionProperties;
        this.zookeeperClient = ((ZookeeperClientManager)AradinBeanFactory.getBean(ZookeeperClientManager.class)).getClient(versionProperties.getZookeeperAddressId());
    }

    public void broadcast(String group, String key) {
        String path = "/" + this.versionProperties.getZookeeperAddressId() + "/" + group + "/" + key;
        String value = this.versionGentor.nextVersion(path);
        try {
            this.zookeeperClient.createContainers(path);
            this.zookeeperClient.setData().forPath(path, value.getBytes(Charset.forName("utf-8")));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getCause());
        }
    }
}

