/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.version.nacos.starter.manager;

import cn.aradin.version.nacos.starter.properties.VersionNacosProperties;
import com.alibaba.cloud.nacos.NacosConfigProperties;
import com.alibaba.cloud.nacos.diagnostics.analyzer.NacosConnectionFailureException;
import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class VersionNacosConfigManager {
    private static final Logger log = LoggerFactory.getLogger(VersionNacosConfigManager.class);
    private static ConfigService service = null;
    private NacosConfigProperties nacosConfigProperties = new NacosConfigProperties();

    public VersionNacosConfigManager(NacosConfigProperties nacosConfigProperties, VersionNacosProperties versionNacos) {
        BeanUtils.copyProperties((Object)nacosConfigProperties, (Object)this.nacosConfigProperties);
        if (StringUtils.isNotBlank((CharSequence)versionNacos.getServerAddr())) {
            this.nacosConfigProperties.setServerAddr(versionNacos.getServerAddr());
        }
        if (StringUtils.isNotBlank((CharSequence)versionNacos.getNamespace())) {
            this.nacosConfigProperties.setNamespace(versionNacos.getNamespace());
        }
        if (StringUtils.isNotBlank((CharSequence)versionNacos.getUsername())) {
            this.nacosConfigProperties.setUsername(versionNacos.getUsername());
        }
        if (StringUtils.isNotBlank((CharSequence)versionNacos.getPassword())) {
            this.nacosConfigProperties.setPassword(versionNacos.getPassword());
        }
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.nacosConfigProperties.getServerAddr(), this.nacosConfigProperties.getNamespace(), this.nacosConfigProperties.getUsername(), this.nacosConfigProperties.getPassword()})) {
            throw new RuntimeException("Nacos\u914d\u7f6e\u4e0d\u5168");
        }
        VersionNacosConfigManager.createConfigService(this.nacosConfigProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ConfigService createConfigService(NacosConfigProperties nacosConfigProperties) {
        if (!Objects.isNull(service)) return service;
        Class<VersionNacosConfigManager> clazz = VersionNacosConfigManager.class;
        synchronized (VersionNacosConfigManager.class) {
            try {
                if (!Objects.isNull(service)) return service;
                service = NacosFactory.createConfigService((Properties)nacosConfigProperties.assembleConfigServiceProperties());
            }
            catch (NacosException e) {
                log.error(e.getMessage());
                throw new NacosConnectionFailureException(nacosConfigProperties.getServerAddr(), e.getMessage(), (Throwable)e);
            }
            return service;
        }
    }

    public ConfigService getConfigService() {
        if (Objects.isNull(service)) {
            VersionNacosConfigManager.createConfigService(this.nacosConfigProperties);
        }
        return service;
    }

    public NacosConfigProperties getNacosConfigProperties() {
        return this.nacosConfigProperties;
    }
}

