/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.version.nacos.starter.handler;

import cn.aradin.version.core.dispatcher.VersionDispatcher;
import cn.aradin.version.core.gentor.IVersionGentor;
import cn.aradin.version.core.handler.IVersionBroadHandler;
import cn.aradin.version.core.properties.VersionNacos;
import cn.aradin.version.nacos.starter.listener.VersionNacosConfigListener;
import com.alibaba.cloud.nacos.NacosConfigManager;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;

public class VersionNacosBroadHandler
implements IVersionBroadHandler {
    private ConfigService configService;
    private IVersionGentor versionGentor;

    public VersionNacosBroadHandler(VersionNacos versionNacos, NacosConfigManager nacosConfigManager, VersionDispatcher versionDispatcher, IVersionGentor versionGentor) {
        try {
            this.configService = nacosConfigManager.getConfigService();
            this.configService.addListener(versionNacos.getDataId(), versionNacos.getGroup(), (Listener)new VersionNacosConfigListener(versionDispatcher, versionNacos.getGroup(), versionNacos.getDataId()));
        }
        catch (NacosException e) {
            throw new RuntimeException("VersionNacosBroadHandler Init-Failed " + e.getMessage());
        }
    }

    public void broadcast(String group, String key) {
        this.broadcast(group, key, this.versionGentor.nextVersion(group));
    }

    public void broadcast(String group, String key, String version) {
        try {
            this.configService.publishConfig(key, group, version);
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }
}

