/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.webwall.starter.xss.filter;

import cn.aradin.spring.webwall.starter.xss.XssConverter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    HttpServletRequest orgRequest = null;

    public XssHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
        this.orgRequest = request;
    }

    public String getParameter(String name) {
        String value = super.getParameter(XssConverter.xssEncode(name));
        if (value != null) {
            value = XssConverter.xssEncode(value);
        }
        return value;
    }

    public String getHeader(String name) {
        String value = super.getHeader(XssConverter.xssEncode(name));
        if (value != null) {
            value = XssConverter.xssEncode(value);
        }
        return value;
    }

    public HttpServletRequest getOrgRequest() {
        return this.orgRequest;
    }

    public static HttpServletRequest getOrgRequest(HttpServletRequest req) {
        if (req instanceof XssHttpServletRequestWrapper) {
            return ((XssHttpServletRequestWrapper)req).getOrgRequest();
        }
        return req;
    }
}

