/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.salarm.starter.notifier;

import cn.aradin.spring.core.thread.AradinThreadManager;
import cn.aradin.spring.salarm.starter.enums.SalarmDuty;
import cn.aradin.spring.salarm.starter.enums.SalarmLevel;
import cn.aradin.spring.salarm.starter.handler.ISalarmHandler;
import cn.aradin.spring.salarm.starter.notifier.ISalarm;
import cn.aradin.spring.salarm.starter.properties.SalarmProperties;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.data.redis.core.RedisTemplate;

public class SalarmImpl
implements ISalarm {
    private static final Logger log = LoggerFactory.getLogger(SalarmImpl.class);
    private SalarmProperties salarmProperties;
    private List<ISalarmHandler> handlers = Lists.newArrayList();
    private RedisTemplate<Object, Object> redisTemplate;
    private static final String FORMAT_STACK = "SALARM Position {} : {} : [ {} ]";

    public SalarmImpl(RedisTemplate<Object, Object> redisTemplate, SalarmProperties salarmProperties, List<ISalarmHandler> handlers) {
        if (salarmProperties == null || salarmProperties.getTtl() == null || salarmProperties.getLevel() == null) {
            throw new RuntimeException("Unconfigured properties with aradin.salarm.*");
        }
        this.salarmProperties = salarmProperties;
        this.redisTemplate = redisTemplate;
        if (CollectionUtils.isNotEmpty(handlers)) {
            this.handlers.addAll(handlers);
        }
    }

    private String format(String format, Object ... args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)format, (Object[])args);
        return ft.getMessage();
    }

    private void send(SalarmLevel level, String type, String content) {
        for (ISalarmHandler handler : this.handlers) {
            if (!handler.isSupported(level)) continue;
            handler.notify(level, type, content);
        }
    }

    @Override
    public void salarm(final SalarmLevel level, final SalarmDuty duty, final String typeOrFormat, final String contentOrFormat, final Object ... params) {
        if (level != null && this.salarmProperties.getLevel().compareTo(level) <= 0) {
            CompletableFuture.runAsync(new Runnable(){

                @Override
                public void run() {
                    try {
                        StackTraceElement[] stacks;
                        String type = typeOrFormat;
                        if (params != null) {
                            type = SalarmImpl.this.format(typeOrFormat, params);
                        }
                        if (SalarmImpl.this.redisTemplate.opsForValue().increment((Object)type) > 1L) {
                            if (log.isDebugEnabled()) {
                                log.debug("Repeat Alarm {}", (Object)type);
                            }
                            return;
                        }
                        SalarmImpl.this.redisTemplate.expire((Object)type, SalarmImpl.this.salarmProperties.getTtl());
                        StringBuilder strBud = new StringBuilder();
                        if (SalarmDuty.deve.equals((Object)duty) && (stacks = Thread.currentThread().getStackTrace()).length >= 3) {
                            StackTraceElement stack = stacks[stacks.length - 2];
                            strBud.append(SalarmImpl.this.format(SalarmImpl.FORMAT_STACK, new Object[]{stack.getClassName(), stack.getMethodName(), stack.getLineNumber()}));
                            strBud.append("\n");
                        }
                        if (params != null) {
                            strBud.append(SalarmImpl.this.format(contentOrFormat, params));
                        } else {
                            strBud.append(contentOrFormat);
                        }
                        SalarmImpl.this.send(level, type, strBud.toString());
                    }
                    catch (Exception e) {
                        log.error("Salarm Failed For {} , {}", (Object)e.getMessage(), (Object)e.getCause());
                    }
                }
            }, AradinThreadManager.getShortPool());
        }
    }

    @Override
    public void trace(SalarmDuty duty, String typeOrFormat, String contentOrFormat, Object ... params) {
        this.salarm(SalarmLevel.trace, duty, typeOrFormat, contentOrFormat, params);
    }

    @Override
    public void info(SalarmDuty duty, String typeOrFormat, String contentOrFormat, Object ... params) {
        this.salarm(SalarmLevel.info, duty, typeOrFormat, contentOrFormat, params);
    }

    @Override
    public void warn(SalarmDuty duty, String typeOrFormat, String contentOrFormat, Object ... params) {
        this.salarm(SalarmLevel.warn, duty, typeOrFormat, contentOrFormat, params);
    }

    @Override
    public void error(SalarmDuty duty, String typeOrFormat, String contentOrFormat, Object ... params) {
        this.salarm(SalarmLevel.error, duty, typeOrFormat, contentOrFormat, params);
    }

    @Override
    public void trace(String typeOrFormat, String contentOrFormat, Object ... params) {
        this.trace(SalarmDuty.user, typeOrFormat, contentOrFormat, params);
    }

    @Override
    public void info(String typeOrFormat, String contentOrFormat, Object ... params) {
        this.info(SalarmDuty.user, typeOrFormat, contentOrFormat, params);
    }

    @Override
    public void warn(String typeOrFormat, String contentOrFormat, Object ... params) {
        this.warn(SalarmDuty.user, typeOrFormat, contentOrFormat, params);
    }

    @Override
    public void error(String typeOrFormat, String contentOrFormat, Object ... params) {
        this.error(SalarmDuty.user, typeOrFormat, contentOrFormat, params);
    }
}

