/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.redisson.starter;

import cn.aradin.spring.redis.starter.AradinRedisAutoConfiguration;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.data.redis.RedisProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.ReflectionUtils;

@Configuration
@EnableCaching
@ConditionalOnClass(value={Redisson.class, RedisOperations.class})
@AutoConfigureAfter(value={AradinRedisAutoConfiguration.class})
@EnableConfigurationProperties(value={RedisProperties.class})
public class AradinRedissonAutoConfiguration {
    @Autowired
    private RedisProperties redisProperties;

    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public RedissonConnectionFactory redissonConnectionFactory(RedissonClient redisson) {
        return new RedissonConnectionFactory(redisson);
    }

    @Bean(destroyMethod="shutdown")
    @ConditionalOnMissingBean
    public RedissonClient redisson() throws IOException {
        int timeout;
        Config config = null;
        Method clusterMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getCluster");
        Method timeoutMethod = ReflectionUtils.findMethod(RedisProperties.class, (String)"getTimeout");
        Object timeoutValue = ReflectionUtils.invokeMethod((Method)timeoutMethod, (Object)this.redisProperties);
        if (null == timeoutValue) {
            timeout = 0;
        } else if (!(timeoutValue instanceof Integer)) {
            Method millisMethod = ReflectionUtils.findMethod(timeoutValue.getClass(), (String)"toMillis");
            timeout = ((Long)ReflectionUtils.invokeMethod((Method)millisMethod, (Object)timeoutValue)).intValue();
        } else {
            timeout = (Integer)timeoutValue;
        }
        if (this.redisProperties.getSentinel() != null) {
            Method nodesMethod = ReflectionUtils.findMethod(RedisProperties.Sentinel.class, (String)"getNodes");
            Object nodesValue = ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)this.redisProperties.getSentinel());
            String[] nodes = nodesValue instanceof String ? this.convert(Arrays.asList(((String)nodesValue).split(","))) : this.convert((List)nodesValue);
            config = new Config();
            ((SentinelServersConfig)config.useSentinelServers().setMasterName(this.redisProperties.getSentinel().getMaster()).addSentinelAddress(nodes).setDatabase(this.redisProperties.getDatabase()).setConnectTimeout(timeout)).setPassword(this.redisProperties.getPassword());
        } else if (clusterMethod != null && ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties) != null) {
            Object clusterObject = ReflectionUtils.invokeMethod((Method)clusterMethod, (Object)this.redisProperties);
            Method nodesMethod = ReflectionUtils.findMethod(clusterObject.getClass(), (String)"getNodes");
            List nodesObject = (List)ReflectionUtils.invokeMethod((Method)nodesMethod, (Object)clusterObject);
            String[] nodes = this.convert(nodesObject);
            config = new Config();
            ((ClusterServersConfig)config.useClusterServers().addNodeAddress(nodes).setConnectTimeout(timeout)).setPassword(this.redisProperties.getPassword());
        } else {
            config = new Config();
            String prefix = "redis://";
            Method method = ReflectionUtils.findMethod(RedisProperties.class, (String)"isSsl");
            if (method != null && ((Boolean)ReflectionUtils.invokeMethod((Method)method, (Object)this.redisProperties)).booleanValue()) {
                prefix = "rediss://";
            }
            ((SingleServerConfig)config.useSingleServer().setAddress(prefix + this.redisProperties.getHost() + ":" + this.redisProperties.getPort()).setConnectTimeout(timeout)).setDatabase(this.redisProperties.getDatabase()).setPassword(this.redisProperties.getPassword());
        }
        return Redisson.create((Config)config);
    }

    private String[] convert(List<String> nodesObject) {
        ArrayList<String> nodes = new ArrayList<String>(nodesObject.size());
        for (String node : nodesObject) {
            if (!node.startsWith("redis://") && !node.startsWith("rediss://")) {
                nodes.add("redis://" + node);
                continue;
            }
            nodes.add(node);
        }
        return nodes.toArray(new String[nodes.size()]);
    }
}

