/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.redis.starter.core;

import cn.aradin.spring.redis.starter.core.BucketHashOperations;
import cn.aradin.spring.redis.starter.core.BucketSetOperations;
import cn.aradin.spring.redis.starter.core.ClusterBucketSetOperations;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisBucketTemplate<V>
extends RedisTemplate<String, V> {
    public <HK, HV> BucketHashOperations<HK, HV> opsForHash(int bucket) {
        return new BucketHashOperations(this, bucket);
    }

    public BucketSetOperations<String, V> opsForSet(int bucket) {
        return new BucketSetOperations(this, bucket);
    }

    public ClusterBucketSetOperations<String, V> opsForClusterSet(int bucket) {
        return new ClusterBucketSetOperations(this, bucket);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        throw new UnsupportedOperationException("Bucket expire at key-level is not supported. You need operate it at bucket-level from operations-class.");
    }

    public Boolean expireAt(String key, Date date) {
        throw new UnsupportedOperationException("Bucket expireAt is not supported. You need operate it at bucket-level from operations-class.");
    }

    public Boolean delete(String key) {
        throw new UnsupportedOperationException("Bucket delete at key-level is not supported. You need operate it at bucket-level from operations-class.");
    }

    public Long delete(Collection<String> keys) {
        throw new UnsupportedOperationException("Bucket delete at key-level is not supported. You need operate it at bucket-level from operations-class.");
    }
}

