/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.redis.starter.core;

import cn.aradin.spring.core.annotation.UnSafe;
import cn.aradin.spring.redis.starter.core.BucketSetOperations;
import cn.aradin.spring.redis.starter.core.annotation.NotSupport;
import cn.aradin.spring.redis.starter.core.enums.RedisModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.redis.core.RedisTemplate;

@UnSafe(value="Multi-keys operation in local memory")
@NotSupport(value={RedisModel.SINGLE, RedisModel.MASTER_SLAVE})
public class ClusterBucketSetOperations<K, V>
extends BucketSetOperations<K, V> {
    ClusterBucketSetOperations(RedisTemplate<K, V> template, int bucket) {
        super(template, bucket);
    }

    private Collection<byte[]> difference(byte[][] rawKeys) {
        return (Collection)this.execute(connection -> {
            HashSet result = new HashSet();
            if (rawKeys.length > 1) {
                Set base = connection.setCommands().sMembers(rawKeys[0]);
                for (int j = 1; j < rawKeys.length; ++j) {
                    Set set = connection.setCommands().sMembers(rawKeys[j]);
                    if (!CollectionUtils.isNotEmpty((Collection)set)) continue;
                    result.addAll(CollectionUtils.subtract((Iterable)set, (Iterable)base));
                }
            }
            return result;
        });
    }

    @Override
    public Set<V> difference(K key, K otherKey) {
        return this.difference(Arrays.asList(key, otherKey));
    }

    @Override
    public Set<V> difference(K key, Collection<K> otherKeys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            Collection<byte[]> rawValue = this.difference(rawKeys);
            if (!CollectionUtils.isNotEmpty(rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> difference(Collection<K> keys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(keys, i);
            Collection<byte[]> rawValue = this.difference(rawKeys);
            if (!CollectionUtils.isNotEmpty(rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    private Long differenceAndStore(byte[][] rawKeys, byte[] rawDestKey) {
        return (Long)this.execute(connection -> {
            HashSet result = new HashSet();
            if (rawKeys.length > 1) {
                Set base = connection.setCommands().sMembers(rawKeys[0]);
                for (int j = 1; j < rawKeys.length; ++j) {
                    Set set = connection.setCommands().sMembers(rawKeys[j]);
                    if (!CollectionUtils.isNotEmpty((Collection)set)) continue;
                    result.addAll(CollectionUtils.subtract((Iterable)set, (Iterable)base));
                }
                if (CollectionUtils.isNotEmpty(result)) {
                    byte[][] rawValues = new byte[result.size()][];
                    int j = 0;
                    for (byte[] rawValue : result) {
                        rawValues[j++] = rawValue;
                    }
                    connection.setCommands().sAdd(rawDestKey, (byte[][])rawValues);
                }
            }
            return result.size();
        });
    }

    @Override
    public Long differenceAndStore(K key, K otherKey, K destKey) {
        return this.differenceAndStore(Arrays.asList(key, otherKey), destKey);
    }

    @Override
    public Long differenceAndStore(K key, Collection<K> otherKeys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawDestKey = this.rawKey(destKey, i);
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            Long count = this.differenceAndStore(rawKeys, rawDestKey);
            counts = counts + count;
        }
        return counts;
    }

    @Override
    public Long differenceAndStore(Collection<K> keys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawDestKey;
            byte[][] rawKeys = this.rawKeys(keys, i);
            Long count = this.differenceAndStore(rawKeys, rawDestKey = this.rawKey(destKey, i));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    @Override
    public Set<V> intersect(K key, K otherKey) {
        return this.intersect(Arrays.asList(key, otherKey));
    }

    private Collection<byte[]> intersect(byte[][] rawKeys) {
        return (Collection)this.execute(connection -> {
            Collection base = null;
            for (int j = 0; j < rawKeys.length; ++j) {
                Set set = connection.setCommands().sMembers(rawKeys[j]);
                if (CollectionUtils.isEmpty((Collection)(base = base == null ? set : CollectionUtils.intersection((Iterable)base, (Iterable)set)))) break;
            }
            return base;
        });
    }

    @Override
    public Set<V> intersect(K key, Collection<K> otherKeys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            Collection<byte[]> rawValue = this.intersect(rawKeys);
            if (!CollectionUtils.isNotEmpty(rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> intersect(Collection<K> keys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(keys, i);
            Collection<byte[]> rawValue = this.intersect(rawKeys);
            if (!CollectionUtils.isNotEmpty(rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    private Long intersectAndStore(byte[][] rawKeys, byte[] rawDestKey) {
        return (Long)this.execute(connection -> {
            Long count = 0L;
            Collection base = null;
            for (int j = 0; j < rawKeys.length; ++j) {
                Set set = connection.setCommands().sMembers(rawKeys[j]);
                if (base == null) {
                    base = set;
                } else if (set != null) {
                    base = CollectionUtils.intersection((Iterable)base, (Iterable)set);
                }
                if (CollectionUtils.isEmpty((Collection)base)) break;
            }
            if (CollectionUtils.isNotEmpty(base)) {
                byte[][] rawValues = new byte[base.size()][];
                int j = 0;
                for (byte[] rawValue : base) {
                    rawValues[j++] = rawValue;
                }
                count = count + connection.setCommands().sAdd(rawDestKey, (byte[][])rawValues);
            }
            return count;
        });
    }

    @Override
    public Long intersectAndStore(K key, K otherKey, K destKey) {
        return this.intersectAndStore(Arrays.asList(key, otherKey), destKey);
    }

    @Override
    public Long intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawDestKey;
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            Long count = this.intersectAndStore(rawKeys, rawDestKey = this.rawKey(destKey, i));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    @Override
    public Long intersectAndStore(Collection<K> keys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawDestKey;
            byte[][] rawKeys = this.rawKeys(keys, i);
            Long count = this.intersectAndStore(rawKeys, rawDestKey = this.rawKey(destKey, i));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    @Override
    public Boolean move(K key, V value, K destKey) {
        byte[] rawKey = this.rawKey(key, value);
        byte[] rawDestKey = this.rawKey(destKey, value);
        byte[] rawValue = this.rawValue(value);
        return (Boolean)this.execute(connection -> {
            connection.setCommands().sRem(rawKey, (byte[][])new byte[][]{rawValue});
            connection.setCommands().sAdd(rawDestKey, (byte[][])new byte[][]{rawValue});
            return true;
        });
    }

    private Collection<byte[]> union(byte[][] rawKeys) {
        return (Collection)this.execute(connection -> {
            Collection base = null;
            for (int i = 0; i < rawKeys.length; ++i) {
                Set set = connection.setCommands().sMembers(rawKeys[i]);
                if (base == null) {
                    base = set;
                    continue;
                }
                if (set == null) continue;
                base = CollectionUtils.union((Iterable)base, (Iterable)set);
            }
            return base;
        });
    }

    @Override
    public Set<V> union(K key, K otherKey) {
        return this.union(Arrays.asList(key, otherKey));
    }

    @Override
    public Set<V> union(K key, Collection<K> otherKeys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            Collection<byte[]> rawValue = this.union(rawKeys);
            if (!CollectionUtils.isNotEmpty(rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    @Override
    public Set<V> union(Collection<K> keys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(keys, i);
            Collection<byte[]> rawValue = this.union(rawKeys);
            if (!CollectionUtils.isNotEmpty(rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    private Long unionAndStore(byte[][] rawKeys, byte[] rawDestKey) {
        return (Long)this.execute(connection -> {
            Long count = 0L;
            Collection base = null;
            for (int i = 0; i < rawKeys.length; ++i) {
                Set set = connection.setCommands().sMembers(rawKeys[i]);
                if (base == null) {
                    base = set;
                    continue;
                }
                if (set == null) continue;
                base = CollectionUtils.union((Iterable)base, (Iterable)set);
            }
            if (CollectionUtils.isNotEmpty(base)) {
                byte[][] rawValues = new byte[base.size()][];
                int j = 0;
                for (byte[] rawValue : base) {
                    rawValues[j++] = rawValue;
                }
                count = count + connection.setCommands().sAdd(rawDestKey, (byte[][])rawValues);
            }
            return count;
        });
    }

    @Override
    public Long unionAndStore(K key, K otherKey, K destKey) {
        return this.unionAndStore(Arrays.asList(key, otherKey), destKey);
    }

    @Override
    public Long unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawDestKey;
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            Long count = this.unionAndStore(rawKeys, rawDestKey = this.rawKey(destKey, i));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    @Override
    public Long unionAndStore(Collection<K> keys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawDestKey;
            byte[][] rawKeys = this.rawKeys(keys, i);
            Long count = this.unionAndStore(rawKeys, rawDestKey = this.rawKey(destKey, i));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }
}

