/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.redis.starter.core;

import cn.aradin.spring.redis.starter.core.AbstractBucketOperations;
import cn.aradin.spring.redis.starter.core.annotation.NotSuggest;
import cn.aradin.spring.redis.starter.core.annotation.NotSupport;
import cn.aradin.spring.redis.starter.core.enums.RedisModel;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.SetOperations;

@NotSupport(value={RedisModel.CLUSTER})
public class BucketSetOperations<K, V>
extends AbstractBucketOperations<K, V>
implements SetOperations<K, V> {
    BucketSetOperations(RedisTemplate<K, V> template, int bucket) {
        super(template, bucket);
    }

    public Long add(K key, V ... values) {
        Long counts = 0L;
        if (values.length == 1) {
            byte[] rawValue;
            byte[] rawKey = this.rawKey(key, values[0]);
            Long l = (Long)this.execute(arg_0 -> BucketSetOperations.lambda$add$0(rawKey, rawValue = this.rawValue(values[0]), arg_0));
            if (l != null) {
                counts = counts + l;
            }
        } else {
            HashMap<Integer, ArrayList> bucketValues = new HashMap<Integer, ArrayList>();
            for (V value : values) {
                if (value == null) continue;
                Integer bucket = this.bucket(value);
                if (bucketValues.get(bucket) == null) {
                    bucketValues.put(bucket, Lists.newArrayList());
                }
                ((Collection)bucketValues.get(bucket)).add(value);
            }
            for (Map.Entry entry : bucketValues.entrySet()) {
                byte[][] rawValues;
                byte[] rawKey = this.rawKey(key, (Integer)entry.getKey());
                Long count = (Long)this.execute(arg_0 -> BucketSetOperations.lambda$add$1(rawKey, rawValues = this.rawValues(((Collection)entry.getValue()).toArray()), arg_0));
                if (count == null) continue;
                counts = counts + count;
            }
        }
        return counts;
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Set<V> difference(K key, K otherKey) {
        return this.difference(Arrays.asList(key, otherKey));
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Set<V> difference(K key, Collection<K> otherKeys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            Set rawValue = (Set)this.execute(connection -> connection.setCommands().sDiff(rawKeys));
            if (!CollectionUtils.isNotEmpty((Collection)rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Set<V> difference(Collection<K> keys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(keys, i);
            Set rawValue = (Set)this.execute(connection -> connection.setCommands().sDiff(rawKeys));
            if (!CollectionUtils.isNotEmpty((Collection)rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Long differenceAndStore(K key, K otherKey, K destKey) {
        return this.differenceAndStore(Arrays.asList(key, otherKey), destKey);
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Long differenceAndStore(K key, Collection<K> otherKeys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            byte[] rawDestKey = this.rawKey(destKey, i);
            Long count = (Long)this.execute(connection -> connection.setCommands().sDiffStore(rawDestKey, rawKeys));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Long differenceAndStore(Collection<K> keys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(keys, i);
            byte[] rawDestKey = this.rawKey(destKey, i);
            Long count = (Long)this.execute(connection -> connection.setCommands().sDiffStore(rawDestKey, rawKeys));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Set<V> intersect(K key, K otherKey) {
        return this.intersect(Arrays.asList(key, otherKey));
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Set<V> intersect(K key, Collection<K> otherKeys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            Set rawValue = (Set)this.execute(connection -> connection.setCommands().sInter(rawKeys));
            if (!CollectionUtils.isNotEmpty((Collection)rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Set<V> intersect(Collection<K> keys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(keys, i);
            Set rawValue = (Set)this.execute(connection -> connection.setCommands().sInter(rawKeys));
            if (!CollectionUtils.isNotEmpty((Collection)rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Long intersectAndStore(K key, K otherKey, K destKey) {
        return this.intersectAndStore(Arrays.asList(key, otherKey), destKey);
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Long intersectAndStore(K key, Collection<K> otherKeys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            byte[] rawDestKey = this.rawKey(destKey, i);
            Long count = (Long)this.execute(connection -> connection.setCommands().sInterStore(rawDestKey, rawKeys));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Long intersectAndStore(Collection<K> keys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(keys, i);
            byte[] rawDestKey = this.rawKey(destKey, i);
            Long count = (Long)this.execute(connection -> connection.setCommands().sInterStore(rawDestKey, rawKeys));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    public Boolean isMember(K key, Object o) {
        byte[] rawKey = this.rawKey(key, o);
        byte[] rawValue = this.rawValue(o);
        return (Boolean)this.execute(connection -> connection.setCommands().sIsMember(rawKey, rawValue));
    }

    @NotSuggest
    public Map<Object, Boolean> isMember(K key, Object ... objects) {
        return (Map)this.execute(connection -> {
            LinkedHashMap<Object, Boolean> isMember = new LinkedHashMap<Object, Boolean>(objects.length);
            for (Object object : objects) {
                byte[] rawKey = this.rawKey(key, object);
                Boolean result = connection.setCommands().sIsMember(rawKey, this.rawValue(object));
                if (result == null || !result.booleanValue()) {
                    isMember.put(object, false);
                    continue;
                }
                isMember.put(object, true);
            }
            return isMember;
        });
    }

    public Set<V> members(K key) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawKey = this.rawKey(key, i);
            Set rawValue = (Set)this.execute(connection -> connection.setCommands().sMembers(rawKey));
            if (!CollectionUtils.isNotEmpty((Collection)rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Boolean move(K key, V value, K destKey) {
        byte[] rawKey = this.rawKey(key, value);
        byte[] rawDestKey = this.rawKey(destKey, value);
        byte[] rawValue = this.rawValue(value);
        return (Boolean)this.execute(connection -> connection.setCommands().sMove(rawKey, rawDestKey, rawValue));
    }

    @NotSuggest
    public V randomMember(K key) {
        return (V)this.execute(new AbstractBucketOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.setCommands().sRandMember(rawKey);
            }
        });
    }

    @Deprecated
    public Set<V> distinctRandomMembers(K key, long count) {
        throw new UnsupportedOperationException("Bucket distinctRandomMembers is not supported");
    }

    @Deprecated
    public List<V> randomMembers(K key, long count) {
        throw new UnsupportedOperationException("Bucket randomMembers is not supported");
    }

    public Long remove(K key, Object ... values) {
        Long counts = 0L;
        for (Object value : values) {
            byte[][] rawValues;
            byte[] rawKey = this.rawKey(key, value);
            Long count = (Long)this.execute(arg_0 -> BucketSetOperations.lambda$remove$14(rawKey, rawValues = this.rawValues(values), arg_0));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    public V pop(K key) {
        return (V)this.execute(new AbstractBucketOperations.ValueDeserializingRedisCallback(key){

            @Override
            protected byte[] inRedis(byte[] rawKey, RedisConnection connection) {
                return connection.setCommands().sPop(rawKey);
            }
        });
    }

    @NotSuggest
    public List<V> pop(K key, long count) {
        V value;
        ArrayList values = null;
        while (count-- > 0L && (value = this.pop(key)) != null) {
            if (values == null) {
                values = Lists.newArrayList();
            }
            values.add(value);
        }
        return values;
    }

    public Long size(K key) {
        Long sizes = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawKey = this.rawKey(key, i);
            Long size = (Long)this.execute(connection -> connection.setCommands().sCard(rawKey));
            if (size == null) continue;
            sizes = sizes + size;
        }
        return sizes;
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Set<V> union(K key, K otherKey) {
        return this.union(Arrays.asList(key, otherKey));
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Set<V> union(K key, Collection<K> otherKeys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            Set rawValue = (Set)this.execute(connection -> connection.setCommands().sUnion(rawKeys));
            if (!CollectionUtils.isNotEmpty((Collection)rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Set<V> union(Collection<K> keys) {
        HashSet<byte[]> rawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(keys, i);
            Set rawValue = (Set)this.execute(connection -> connection.setCommands().sUnion(rawKeys));
            if (!CollectionUtils.isNotEmpty((Collection)rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeValues(rawValues);
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Long unionAndStore(K key, K otherKey, K destKey) {
        return this.unionAndStore(Arrays.asList(key, otherKey), destKey);
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Long unionAndStore(K key, Collection<K> otherKeys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(key, otherKeys, i);
            byte[] rawDestKey = this.rawKey(destKey, i);
            Long count = (Long)this.execute(connection -> connection.setCommands().sUnionStore(rawDestKey, rawKeys));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    @NotSupport(value={RedisModel.CLUSTER})
    public Long unionAndStore(Collection<K> keys, K destKey) {
        Long counts = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(keys, i);
            byte[] rawDestKey = this.rawKey(destKey, i);
            Long count = (Long)this.execute(connection -> connection.setCommands().sUnionStore(rawDestKey, rawKeys));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    public Cursor<V> scan(K key, ScanOptions options) {
        throw new UnsupportedOperationException("Bucket scan is not supported");
    }

    private static /* synthetic */ Long lambda$remove$14(byte[] rawKey, byte[][] rawValues, RedisConnection connection) throws DataAccessException {
        return connection.setCommands().sRem(rawKey, rawValues);
    }

    private static /* synthetic */ Long lambda$add$1(byte[] rawKey, byte[][] rawValues, RedisConnection connection) throws DataAccessException {
        return connection.setCommands().sAdd(rawKey, rawValues);
    }

    private static /* synthetic */ Long lambda$add$0(byte[] rawKey, byte[] rawValue, RedisConnection connection) throws DataAccessException {
        return connection.setCommands().sAdd(rawKey, (byte[][])new byte[][]{rawValue});
    }
}

