/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.redis.starter.core;

import cn.aradin.spring.redis.starter.core.AbstractBucketOperations;
import cn.aradin.spring.redis.starter.core.annotation.NotSuggest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class BucketHashOperations<HK, HV>
extends AbstractBucketOperations<String, Object>
implements HashOperations<String, HK, HV> {
    BucketHashOperations(RedisTemplate<String, ?> template, int bucket) {
        super(template, bucket);
    }

    public HV get(String key, Object hashKey) {
        byte[] rawHashKey;
        byte[] rawKey = this.rawKey((Object)key, hashKey);
        byte[] rawHashValue = (byte[])this.execute(arg_0 -> BucketHashOperations.lambda$get$0(rawKey, rawHashKey = this.rawHashKey(hashKey), arg_0));
        return rawHashValue != null ? (HV)this.deserializeHashValue(rawHashValue) : null;
    }

    public Boolean hasKey(String key, Object hashKey) {
        byte[] rawKey = this.rawKey((Object)key, hashKey);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return (Boolean)this.execute(connection -> connection.hashCommands().hExists(rawKey, rawHashKey));
    }

    public Long increment(String key, HK hashKey, long delta) {
        byte[] rawKey = this.rawKey((Object)key, hashKey);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return (Long)this.execute(connection -> connection.hashCommands().hIncrBy(rawKey, rawHashKey, delta));
    }

    public Double increment(String key, HK hashKey, double delta) {
        byte[] rawKey = this.rawKey((Object)key, hashKey);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return (Double)this.execute(connection -> connection.hashCommands().hIncrBy(rawKey, rawHashKey, delta));
    }

    @Nullable
    @NotSuggest
    public HK randomKey(String key) {
        byte[] rawKey = this.rawRandomKey(key);
        return this.deserializeHashKey((byte[])this.execute(connection -> connection.hashCommands().hRandField(rawKey)));
    }

    @Nullable
    @NotSuggest
    public Map.Entry<HK, HV> randomEntry(String key) {
        byte[] rawKey = this.rawRandomKey(key);
        Map.Entry rawEntry = (Map.Entry)this.execute(connection -> connection.hashCommands().hRandFieldWithValues(rawKey));
        return rawEntry == null ? null : Converters.entryOf(this.deserializeHashKey((byte[])rawEntry.getKey()), this.deserializeHashValue((byte[])rawEntry.getValue()));
    }

    @Nullable
    @Deprecated
    public List<HK> randomKeys(String key, long count) {
        byte[] rawKey = this.rawRandomKey(key);
        List rawValues = (List)this.execute(connection -> connection.hashCommands().hRandField(rawKey, count));
        return this.deserializeHashKeys(rawValues);
    }

    @Nullable
    @Deprecated
    public Map<HK, HV> randomEntries(String key, long count) {
        Assert.isTrue((count > 0L ? 1 : 0) != 0, (String)"Count must not be negative");
        byte[] rawKey = this.rawRandomKey(key);
        List rawEntries = (List)this.execute(connection -> connection.hashCommands().hRandFieldWithValues(rawKey, count));
        if (rawEntries == null) {
            return null;
        }
        LinkedHashMap<byte[], byte[]> rawMap = new LinkedHashMap<byte[], byte[]>(rawEntries.size());
        rawEntries.forEach(entry -> rawMap.put((byte[])entry.getKey(), (byte[])entry.getValue()));
        return this.deserializeHashMap(rawMap);
    }

    public Set<HK> keys(String key) {
        HashSet<byte[]> allRawValues = new HashSet<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawKey = this.rawKey((Object)key, i);
            Set rawValues = (Set)this.execute(connection -> connection.hashCommands().hKeys(rawKey));
            if (rawValues == null) continue;
            allRawValues.addAll(rawValues);
        }
        return allRawValues != null ? this.deserializeHashKeys(allRawValues) : Collections.emptySet();
    }

    public Long size(String key) {
        Long sizes = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawKey = this.rawKey((Object)key, i);
            Long size = (Long)this.execute(connection -> connection.hashCommands().hLen(rawKey));
            if (size == null) continue;
            sizes = sizes + size;
        }
        return sizes;
    }

    public Long lengthOfValue(String key, HK hashKey) {
        byte[] rawKey = this.rawKey((Object)key, hashKey);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return (Long)this.execute(connection -> connection.hashCommands().hStrLen(rawKey, rawHashKey));
    }

    public void putAll(String key, Map<? extends HK, ? extends HV> m) {
        if (m.isEmpty()) {
            return;
        }
        LinkedHashMap buckets = new LinkedHashMap(this.bucket);
        for (Map.Entry<HK, HV> entry : m.entrySet()) {
            Integer bucket = this.bucket(entry.getKey());
            if (buckets.get(bucket) == null) {
                buckets.put(bucket, new LinkedHashMap());
            }
            ((Map)buckets.get(bucket)).put(this.rawHashKey(entry.getKey()), this.rawHashValue(entry.getValue()));
        }
        this.execute(connection -> {
            for (Map.Entry bucket : buckets.entrySet()) {
                connection.hashCommands().hMSet(this.rawKey((Object)key, (Integer)bucket.getKey()), (Map)bucket.getValue());
            }
            return null;
        });
    }

    public List<HV> multiGet(String key, Collection<HK> hashKeys) {
        if (hashKeys.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap bucketMap = new HashMap();
        for (HK hashKey : hashKeys) {
            Integer bucket = this.bucket(hashKey);
            if (bucketMap.get(bucket) == null) {
                bucketMap.put(bucket, new ArrayList());
            }
            ((Collection)bucketMap.get(bucket)).add(this.rawHashKey(hashKey));
        }
        ArrayList<byte[]> rawValues = new ArrayList<byte[]>();
        for (Map.Entry entry : bucketMap.entrySet()) {
            byte[] rawKey = this.rawKey((Object)key, (Integer)entry.getKey());
            byte[][] rawHashKeys = new byte[((Collection)entry.getValue()).size()][];
            int counter = 0;
            for (byte[] rawHashKey : (Collection)entry.getValue()) {
                rawHashKeys[counter++] = rawHashKey;
            }
            List rawValue = (List)this.execute(connection -> connection.hashCommands().hMGet(rawKey, rawHashKeys));
            if (!CollectionUtils.isNotEmpty((Collection)rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return this.deserializeHashValues(rawValues);
    }

    public void put(String key, HK hashKey, HV value) {
        byte[] rawKey = this.rawKey((Object)key, hashKey);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        byte[] rawHashValue = this.rawHashValue(value);
        this.execute(connection -> {
            connection.hashCommands().hSet(rawKey, rawHashKey, rawHashValue);
            return null;
        });
    }

    public Boolean putIfAbsent(String key, HK hashKey, HV value) {
        byte[] rawKey = this.rawKey((Object)key, hashKey);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        byte[] rawHashValue = this.rawHashValue(value);
        return (Boolean)this.execute(connection -> connection.hashCommands().hSetNX(rawKey, rawHashKey, rawHashValue));
    }

    public List<HV> values(String key) {
        ArrayList<byte[]> rawValues = new ArrayList<byte[]>();
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawKey = this.rawKey((Object)key, i);
            List rawValue = (List)this.execute(connection -> connection.hashCommands().hVals(rawKey));
            if (!CollectionUtils.isNotEmpty((Collection)rawValue)) continue;
            rawValues.addAll(rawValue);
        }
        return rawValues != null ? this.deserializeHashValues(rawValues) : Collections.emptyList();
    }

    public Long delete(String key, Object ... hashKeys) {
        Long counts = 0L;
        for (Object hashKey : hashKeys) {
            byte[] rawHashKey;
            byte[] rawKey = this.rawKey((Object)key, hashKey);
            Long count = (Long)this.execute(arg_0 -> BucketHashOperations.lambda$delete$17(rawKey, rawHashKey = this.rawHashKey(hashKey), arg_0));
            if (count == null) continue;
            counts = counts + count;
        }
        return counts;
    }

    public Map<HK, HV> entries(String key) {
        Map entries = null;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawKey = this.rawKey((Object)key, i);
            Map entry = (Map)this.execute(connection -> connection.hashCommands().hGetAll(rawKey));
            if (entry == null) continue;
            if (entries == null) {
                entries = entry;
                continue;
            }
            entries.putAll(entry);
        }
        return entries != null ? this.deserializeHashMap(entries) : Collections.emptyMap();
    }

    public Cursor<Map.Entry<HK, HV>> scan(String key, ScanOptions options) {
        throw new UnsupportedOperationException("Scan with no bucket is not supported. Please use scan(String key, ScanOptions options, int bucket) instead.");
    }

    public Cursor<Map.Entry<HK, HV>> scan(String key, ScanOptions options, int bucket) {
        if (bucket >= this.bucket) {
            return null;
        }
        byte[] rawKey = this.rawKey((Object)key, bucket);
        return (Cursor)this.template.executeWithStickyConnection(connection -> new ConvertingCursor(connection.hashCommands().hScan(rawKey, options), new Converter<Map.Entry<byte[], byte[]>, Map.Entry<HK, HV>>(){

            public Map.Entry<HK, HV> convert(Map.Entry<byte[], byte[]> source) {
                return Converters.entryOf(BucketHashOperations.this.deserializeHashKey(source.getKey()), BucketHashOperations.this.deserializeHashValue(source.getValue()));
            }
        }));
    }

    private static /* synthetic */ Long lambda$delete$17(byte[] rawKey, byte[] rawHashKey, RedisConnection connection) throws DataAccessException {
        return connection.hashCommands().hDel(rawKey, (byte[][])new byte[][]{rawHashKey});
    }

    private static /* synthetic */ byte[] lambda$get$0(byte[] rawKey, byte[] rawHashKey, RedisConnection connection) throws DataAccessException {
        return connection.hashCommands().hGet(rawKey, rawHashKey);
    }
}

