/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.redis.starter.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.zset.DefaultTuple;
import org.springframework.data.redis.connection.zset.Tuple;
import org.springframework.data.redis.core.DefaultTypedTuple;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public abstract class AbstractBucketOperations<K, V> {
    Random random = new Random();
    final int bucket;
    final RedisTemplate<K, V> template;

    AbstractBucketOperations(RedisTemplate<K, V> template, int bucket) {
        this.template = template;
        this.bucket = bucket;
    }

    RedisSerializer keySerializer() {
        return this.template.getKeySerializer();
    }

    RedisSerializer valueSerializer() {
        return this.template.getValueSerializer();
    }

    RedisSerializer hashKeySerializer() {
        return this.template.getHashKeySerializer();
    }

    RedisSerializer hashValueSerializer() {
        return this.template.getHashValueSerializer();
    }

    RedisSerializer stringSerializer() {
        return this.template.getStringSerializer();
    }

    @Nullable
    <T> T execute(RedisCallback<T> callback) {
        return (T)this.template.execute(callback, true);
    }

    public RedisOperations<K, V> getOperations() {
        return this.template;
    }

    int bucket(Object hashKey) {
        return Math.abs(hashKey.hashCode()) % this.bucket;
    }

    byte[] rawRandomKey(Object key) {
        return this.rawKey(key + "-" + this.random.nextInt(this.bucket));
    }

    byte[] rawKey(Object key, int index) {
        return this.rawKey(key + "-" + index);
    }

    byte[] rawKey(Object key, Object hashKey) {
        int index = this.bucket(hashKey);
        return this.rawKey(key + "-" + index);
    }

    byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        if (this.keySerializer() == null && key instanceof byte[]) {
            return (byte[])key;
        }
        return this.keySerializer().serialize(key);
    }

    byte[] rawString(String key) {
        return this.stringSerializer().serialize((Object)key);
    }

    byte[] rawValue(Object value) {
        if (this.valueSerializer() == null && value instanceof byte[]) {
            return (byte[])value;
        }
        return this.valueSerializer().serialize(value);
    }

    byte[][] rawValues(Object ... values) {
        byte[][] rawValues = new byte[values.length][];
        int i = 0;
        for (Object value : values) {
            rawValues[i++] = this.rawValue(value);
        }
        return rawValues;
    }

    byte[][] rawValues(Collection<V> values) {
        Assert.notEmpty(values, (String)"Values must not be 'null' or empty.");
        Assert.noNullElements((Object[])values.toArray(), (String)"Values must not contain 'null' value.");
        byte[][] rawValues = new byte[values.size()][];
        int i = 0;
        for (V value : values) {
            rawValues[i++] = this.rawValue(value);
        }
        return rawValues;
    }

    <HK> byte[] rawHashKey(HK hashKey) {
        Assert.notNull(hashKey, (String)"non null hash key required");
        if (this.hashKeySerializer() == null && hashKey instanceof byte[]) {
            return (byte[])hashKey;
        }
        return this.hashKeySerializer().serialize(hashKey);
    }

    <HK> byte[][] rawHashKeys(HK ... hashKeys) {
        byte[][] rawHashKeys = new byte[hashKeys.length][];
        int i = 0;
        for (HK hashKey : hashKeys) {
            rawHashKeys[i++] = this.rawHashKey(hashKey);
        }
        return rawHashKeys;
    }

    <HV> byte[] rawHashValue(HV value) {
        if (this.hashValueSerializer() == null && value instanceof byte[]) {
            return (byte[])value;
        }
        return this.hashValueSerializer().serialize(value);
    }

    byte[][] rawKeys(K key, K otherKey) {
        byte[][] rawKeys = new byte[][]{this.rawKey(key), this.rawKey(key)};
        return rawKeys;
    }

    byte[][] rawKeys(Collection<K> keys) {
        return this.rawKeys((K)null, keys);
    }

    byte[][] rawKeys(Collection<K> keys, int bucket) {
        return this.rawKeys(null, keys, bucket);
    }

    byte[][] rawKeys(K key, Collection<K> keys, int bucket) {
        byte[][] rawKeys = new byte[keys.size() + (key != null ? 1 : 0)][];
        int i = 0;
        if (key != null) {
            rawKeys[i++] = this.rawKey(key, bucket);
        }
        for (K k : keys) {
            rawKeys[i++] = this.rawKey(k, bucket);
        }
        return rawKeys;
    }

    byte[][] rawKeys(K key, Collection<K> keys) {
        byte[][] rawKeys = new byte[keys.size() + (key != null ? 1 : 0)][];
        int i = 0;
        if (key != null) {
            rawKeys[i++] = this.rawKey(key);
        }
        for (K k : keys) {
            rawKeys[i++] = this.rawKey(k);
        }
        return rawKeys;
    }

    Set<V> deserializeValues(Set<byte[]> rawValues) {
        if (this.valueSerializer() == null) {
            return rawValues;
        }
        return SerializationUtils.deserialize(rawValues, (RedisSerializer)this.valueSerializer());
    }

    @Nullable
    Set<ZSetOperations.TypedTuple<V>> deserializeTupleValues(@Nullable Set<Tuple> rawValues) {
        if (rawValues == null) {
            return null;
        }
        LinkedHashSet<ZSetOperations.TypedTuple<V>> set = new LinkedHashSet<ZSetOperations.TypedTuple<V>>(rawValues.size());
        for (Tuple rawValue : rawValues) {
            set.add(this.deserializeTuple(rawValue));
        }
        return set;
    }

    List<ZSetOperations.TypedTuple<V>> deserializeTupleValues(List<Tuple> rawValues) {
        if (rawValues == null) {
            return null;
        }
        ArrayList<ZSetOperations.TypedTuple<V>> set = new ArrayList<ZSetOperations.TypedTuple<V>>(rawValues.size());
        for (Tuple rawValue : rawValues) {
            set.add(this.deserializeTuple(rawValue));
        }
        return set;
    }

    @Nullable
    ZSetOperations.TypedTuple<V> deserializeTuple(@Nullable Tuple tuple) {
        if (tuple == null) {
            return null;
        }
        Object value = tuple.getValue();
        if (this.valueSerializer() != null) {
            value = this.valueSerializer().deserialize(tuple.getValue());
        }
        return new DefaultTypedTuple(value, tuple.getScore());
    }

    Set<Tuple> rawTupleValues(Set<ZSetOperations.TypedTuple<V>> values) {
        if (values == null) {
            return null;
        }
        LinkedHashSet<Tuple> rawTuples = new LinkedHashSet<Tuple>(values.size());
        for (ZSetOperations.TypedTuple<V> value : values) {
            byte[] rawValue = this.valueSerializer() == null && value.getValue() instanceof byte[] ? (byte[])value.getValue() : this.valueSerializer().serialize(value.getValue());
            rawTuples.add((Tuple)new DefaultTuple(rawValue, value.getScore()));
        }
        return rawTuples;
    }

    List<V> deserializeValues(List<byte[]> rawValues) {
        if (this.valueSerializer() == null) {
            return rawValues;
        }
        return SerializationUtils.deserialize(rawValues, (RedisSerializer)this.valueSerializer());
    }

    <T> Set<T> deserializeHashKeys(Set<byte[]> rawKeys) {
        if (this.hashKeySerializer() == null) {
            return rawKeys;
        }
        return SerializationUtils.deserialize(rawKeys, (RedisSerializer)this.hashKeySerializer());
    }

    <T> List<T> deserializeHashKeys(List<byte[]> rawKeys) {
        if (this.hashKeySerializer() == null) {
            return rawKeys;
        }
        return SerializationUtils.deserialize(rawKeys, (RedisSerializer)this.hashKeySerializer());
    }

    <T> List<T> deserializeHashValues(List<byte[]> rawValues) {
        if (this.hashValueSerializer() == null) {
            return rawValues;
        }
        return SerializationUtils.deserialize(rawValues, (RedisSerializer)this.hashValueSerializer());
    }

    <HK, HV> Map<HK, HV> deserializeHashMap(@Nullable Map<byte[], byte[]> entries) {
        if (entries == null) {
            return null;
        }
        LinkedHashMap<HK, HV> map = new LinkedHashMap<HK, HV>(entries.size());
        for (Map.Entry<byte[], byte[]> entry : entries.entrySet()) {
            map.put(this.deserializeHashKey(entry.getKey()), this.deserializeHashValue(entry.getValue()));
        }
        return map;
    }

    K deserializeKey(byte[] value) {
        if (this.keySerializer() == null) {
            return (K)value;
        }
        return (K)this.keySerializer().deserialize(value);
    }

    Set<K> deserializeKeys(Set<byte[]> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptySet();
        }
        LinkedHashSet<K> result = new LinkedHashSet<K>(keys.size());
        for (byte[] key : keys) {
            result.add(this.deserializeKey(key));
        }
        return result;
    }

    V deserializeValue(byte[] value) {
        if (this.valueSerializer() == null) {
            return (V)value;
        }
        return (V)this.valueSerializer().deserialize(value);
    }

    String deserializeString(byte[] value) {
        return (String)this.stringSerializer().deserialize(value);
    }

    <HK> HK deserializeHashKey(byte[] value) {
        if (this.hashKeySerializer() == null) {
            return (HK)value;
        }
        return (HK)this.hashKeySerializer().deserialize(value);
    }

    <HV> HV deserializeHashValue(byte[] value) {
        if (this.hashValueSerializer() == null) {
            return (HV)value;
        }
        return (HV)this.hashValueSerializer().deserialize(value);
    }

    public Boolean expire(K key, long timeout, TimeUnit unit) {
        Boolean result = true;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawKey = this.rawKey(key, i);
            long rawTimeout = TimeoutUtils.toMillis((long)timeout, (TimeUnit)unit);
            result = result & (Boolean)this.execute(connection -> {
                try {
                    return connection.keyCommands().pExpire(rawKey, rawTimeout);
                }
                catch (Exception e) {
                    return connection.keyCommands().pExpire(rawKey, TimeoutUtils.toSeconds((long)timeout, (TimeUnit)unit));
                }
            });
        }
        return result;
    }

    public Boolean expireAt(K key, Date date) {
        Boolean result = true;
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawKey = this.rawKey(key, i);
            result = result & (Boolean)this.execute(connection -> {
                try {
                    return connection.keyCommands().pExpireAt(rawKey, date.getTime());
                }
                catch (Exception e) {
                    return connection.keyCommands().pExpireAt(rawKey, date.getTime() / 1000L);
                }
            });
        }
        return result;
    }

    public Boolean delete(K key) {
        for (int i = 0; i < this.bucket; ++i) {
            byte[] rawKey = this.rawKey(key, i);
            this.execute(connection -> connection.keyCommands().del((byte[][])new byte[][]{rawKey}));
        }
        return true;
    }

    public Long delete(Collection<K> keys) {
        if (CollectionUtils.isEmpty(keys)) {
            return 0L;
        }
        Long count = 0L;
        for (int i = 0; i < this.bucket; ++i) {
            byte[][] rawKeys = this.rawKeys(keys, i);
            count = count + (Long)this.execute(connection -> connection.keyCommands().del(rawKeys));
        }
        return count;
    }

    abstract class ValueDeserializingRedisCallback
    implements RedisCallback<V> {
        private Object key;

        public ValueDeserializingRedisCallback(Object key) {
            this.key = key;
        }

        public final V doInRedis(RedisConnection connection) {
            byte[] result = null;
            for (int i = 0; i < AbstractBucketOperations.this.bucket; ++i) {
                byte[] rawKey = AbstractBucketOperations.this.rawKey(this.key, i);
                result = this.inRedis(rawKey, connection);
                if (result != null) continue;
            }
            return AbstractBucketOperations.this.deserializeValue(result);
        }

        @Nullable
        protected abstract byte[] inRedis(byte[] var1, RedisConnection var2);
    }
}

