/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.redis.starter;

import cn.aradin.spring.redis.starter.AradinRedisAutoConfiguration;
import cn.aradin.spring.redis.starter.cache.AradinRedisCacheWriter;
import cn.aradin.spring.redis.starter.properties.RedisCacheConfiguration;
import cn.aradin.spring.redis.starter.properties.RedisCacheManagerProperties;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizer;
import org.springframework.boot.autoconfigure.cache.CacheManagerCustomizers;
import org.springframework.boot.autoconfigure.cache.CacheProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.interceptor.CacheAspectSupport;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.redis.cache.BatchStrategies;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

@Configuration
@ConditionalOnClass(value={CacheManager.class})
@ConditionalOnBean(value={CacheAspectSupport.class})
@EnableConfigurationProperties(value={RedisCacheManagerProperties.class})
@AutoConfigureAfter(value={AradinRedisAutoConfiguration.class})
public class AradinRedisManagerAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AradinRedisManagerAutoConfiguration.class);
    public static final String CACHE_MANAGER = "cacheManager";

    @Bean
    @ConditionalOnMissingBean
    public CacheManagerCustomizers cacheManagerCustomizers(ObjectProvider<CacheManagerCustomizer<?>> customizers) {
        log.debug("CacheManagerCustomizers Initial");
        return new CacheManagerCustomizers(customizers.orderedStream().collect(Collectors.toList()));
    }

    @Bean
    public CacheManagerValidator cacheAutoConfigurationValidator(RedisCacheManagerProperties redisCacheManagerProperties, ObjectProvider<CacheManager> cacheManager) {
        log.debug("CacheManagerValidator Initial");
        return new CacheManagerValidator(cacheManager);
    }

    @ConditionalOnMissingBean(name={"redisCacheWriter"})
    @Bean(name={"redisCacheWriter"})
    public RedisCacheWriter redisCacheWriter(RedisConnectionFactory redisConnectionFactory, RedisCacheManagerProperties redisCacheManagerProperties) {
        log.debug("RedisCacheWriter Initial");
        return new AradinRedisCacheWriter(redisConnectionFactory, BatchStrategies.keys(), redisCacheManagerProperties);
    }

    @Bean
    @Primary
    public RedisCacheManager cacheManager(RedisCacheWriter redisCacheWriter, ResourceLoader resourceLoader, RedisCacheManagerProperties redisCacheManagerProperties, CacheManagerCustomizers cacheManagerCustomizers) {
        log.debug("RedisCacheManager Initial");
        CacheProperties cacheProperties = new CacheProperties();
        cacheProperties.getRedis().setTimeToLive(redisCacheManagerProperties.getDefaults().getTtl());
        cacheProperties.getRedis().setCacheNullValues(redisCacheManagerProperties.getDefaults().isCacheNullValues());
        cacheProperties.getRedis().setKeyPrefix(redisCacheManagerProperties.getDefaults().getKeyPrefix());
        cacheProperties.getRedis().setUseKeyPrefix(redisCacheManagerProperties.getDefaults().isUsePrefix());
        RedisCacheManager.RedisCacheManagerBuilder builder = RedisCacheManager.builder((RedisCacheWriter)redisCacheWriter).cacheDefaults(this.determineConfiguration(resourceLoader.getClassLoader(), cacheProperties));
        List cacheNames = cacheProperties.getCacheNames();
        if (!cacheNames.isEmpty()) {
            builder.initialCacheNames(new LinkedHashSet(cacheNames));
        }
        log.debug("RedisCacheManager {}", (Object)JSONObject.toJSONString(redisCacheManagerProperties.getConfigs(), (JSONWriter.Feature[])new JSONWriter.Feature[0]));
        if (!redisCacheManagerProperties.getConfigs().isEmpty()) {
            HashMap<String, org.springframework.data.redis.cache.RedisCacheConfiguration> configMap = new HashMap<String, org.springframework.data.redis.cache.RedisCacheConfiguration>();
            for (String cacheName : redisCacheManagerProperties.getConfigs().keySet()) {
                RedisCacheConfiguration redisCacheConfig = redisCacheManagerProperties.getConfigs().get(cacheName);
                if (redisCacheConfig.isUsePrefix() && redisCacheConfig.isCacheNullValues()) {
                    configMap.put(cacheName, org.springframework.data.redis.cache.RedisCacheConfiguration.defaultCacheConfig().entryTtl(redisCacheConfig.getTtl()).prefixCacheNameWith(redisCacheConfig.getKeyPrefix()));
                    continue;
                }
                if (redisCacheConfig.isCacheNullValues()) {
                    configMap.put(cacheName, org.springframework.data.redis.cache.RedisCacheConfiguration.defaultCacheConfig().entryTtl(redisCacheConfig.getTtl()).disableKeyPrefix());
                    continue;
                }
                configMap.put(cacheName, org.springframework.data.redis.cache.RedisCacheConfiguration.defaultCacheConfig().entryTtl(redisCacheConfig.getTtl()).disableKeyPrefix().disableCachingNullValues());
            }
            builder.withInitialCacheConfigurations(configMap);
        }
        return (RedisCacheManager)cacheManagerCustomizers.customize((CacheManager)builder.build());
    }

    private org.springframework.data.redis.cache.RedisCacheConfiguration determineConfiguration(ClassLoader classLoader, CacheProperties cacheProperties) {
        CacheProperties.Redis redisProperties = cacheProperties.getRedis();
        org.springframework.data.redis.cache.RedisCacheConfiguration config = org.springframework.data.redis.cache.RedisCacheConfiguration.defaultCacheConfig();
        config = config.serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer((RedisSerializer)new JdkSerializationRedisSerializer(classLoader)));
        if (redisProperties.getTimeToLive() != null) {
            config = config.entryTtl(redisProperties.getTimeToLive());
        }
        if (redisProperties.getKeyPrefix() != null) {
            config = config.prefixCacheNameWith(redisProperties.getKeyPrefix());
        }
        if (!redisProperties.isCacheNullValues()) {
            config = config.disableCachingNullValues();
        }
        if (!redisProperties.isUseKeyPrefix()) {
            config = config.disableKeyPrefix();
        }
        return config;
    }

    static class CacheManagerValidator
    implements InitializingBean {
        private final ObjectProvider<CacheManager> cacheManager;

        CacheManagerValidator(ObjectProvider<CacheManager> cacheManager) {
            this.cacheManager = cacheManager;
        }

        public void afterPropertiesSet() {
            Assert.notNull((Object)this.cacheManager.getIfAvailable(), () -> "No cache manager could be auto-configured, check your configuration (caching type is 'Aradin Redis')");
        }
    }
}

