/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.utils;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateUtil {
    public static final String FORMAT_ONE = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_TWO = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_THREE = "yyyyMMdd-HHmmss";
    public static final String FORMAT_FOUR = "yyyyMMddHHmmss";
    public static final String FORMAT_FIVE = "yyyy.MM.dd HH:mm:ss";
    public static final String FORMAT_SIX = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String LONG_DATE_FORMAT = "yyyy-MM-dd";
    public static final String LONG_DATE_FORMAT_1 = "yyyy/MM/dd";
    public static final String LONG_DATE_FORMAT_2 = "yyyy.MM.dd";
    public static final String LONG_DATE_FORMAT_3 = "yy.MM.dd";
    public static final String SHORT_DATE_FORMAT = "MM-dd";
    public static final String SHORT = "HH:mm:ss";
    public static final String LONG_TIME_FORMAT = "HH:mm";
    public static final String MONTG_DATE_FORMAT = "yyyy-MM";
    public static final String SIMPLE_DATE_FORMAT = "yyyyMMdd";
    public static final int SUB_YEAR = 1;
    public static final int SUB_MONTH = 2;
    public static final int SUB_DAY = 5;
    public static final int SUB_HOUR = 10;
    public static final int SUB_MINUTE = 12;
    public static final int SUB_SECOND = 13;

    public static Date stringtoDate(String dateStr, String format) {
        Date d = null;
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            formater.setLenient(false);
            d = formater.parse(dateStr);
        }
        catch (Exception e) {
            d = null;
        }
        return d;
    }

    public static Date stringtoDate(String dateStr, String format, ParsePosition pos) {
        Date d = null;
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            formater.setLenient(false);
            d = formater.parse(dateStr, pos);
        }
        catch (Exception e) {
            d = null;
        }
        return d;
    }

    public static int isSameDate(Date date1, Date date2) {
        int date2num;
        int date1num = Integer.valueOf(DateUtil.dateToString(date1, SIMPLE_DATE_FORMAT));
        if (date1num == (date2num = Integer.valueOf(DateUtil.dateToString(date2, SIMPLE_DATE_FORMAT)).intValue())) {
            return 0;
        }
        if (date1num > date2num) {
            return 1;
        }
        return -1;
    }

    public static String dateToStringLong(Date date) {
        return DateUtil.dateToString(date, LONG_DATE_FORMAT);
    }

    public static String dateToString(Date date, String format) {
        if (date == null) {
            return null;
        }
        String result = "";
        if (StringUtils.isBlank((CharSequence)format)) {
            format = FORMAT_ONE;
        }
        SimpleDateFormat formater = new SimpleDateFormat(format);
        try {
            result = formater.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static List<String> getMidpieceDates(String startDate, String endDate, String format) {
        ArrayList<String> list = new ArrayList<String>();
        while (!startDate.equals(endDate)) {
            list.add(startDate);
            startDate = DateUtil.dateToString(DateUtil.nextDay(DateUtil.stringtoDate(startDate, format), 1), format);
        }
        return list;
    }

    public static String getCurrDate(String format) {
        return DateUtil.dateToString(new Date(), format);
    }

    public static Date dateSub(int field, int amount) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.add(field, amount);
            return cal.getTime();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String dateSub(int dateKind, String dateStr, int amount) {
        Date date = DateUtil.stringtoDate(dateStr, FORMAT_ONE);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(dateKind, amount);
        return DateUtil.dateToString(calendar.getTime(), FORMAT_ONE);
    }

    public static long timeSub(String firstTime, String secTime) {
        long first = DateUtil.stringtoDate(firstTime, FORMAT_ONE).getTime();
        long second = DateUtil.stringtoDate(secTime, FORMAT_ONE).getTime();
        return (second - first) / 1000L;
    }

    public static int getDaysOfMonth(String year, String month) {
        int days = 0;
        days = month.equals("1") || month.equals("3") || month.equals("5") || month.equals("7") || month.equals("8") || month.equals("10") || month.equals("12") ? 31 : (month.equals("4") || month.equals("6") || month.equals("9") || month.equals("11") ? 30 : (Integer.parseInt(year) % 4 == 0 && Integer.parseInt(year) % 100 != 0 || Integer.parseInt(year) % 400 == 0 ? 29 : 28));
        return days;
    }

    public static int getDaysOfMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getActualMaximum(5);
    }

    public static int getToday() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(5);
    }

    public static int getToMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static int getToYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(7);
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getDayOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(6);
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static long dayDiff(Date date1, Date date2) {
        return (date2.getTime() - date1.getTime()) / 86400000L;
    }

    public static long dayDiff(String date1, String date2, String format) {
        return DateUtil.dayDiff(DateUtil.stringtoDate(date1, format), DateUtil.stringtoDate(date2, format));
    }

    public static long secondDiff(Date date1, Date date2) {
        return date2.getTime() - date1.getTime();
    }

    public static long secondDiff(String date1, String date2, String format) {
        return DateUtil.secondDiff(DateUtil.stringtoDate(date1, format), DateUtil.stringtoDate(date2, format));
    }

    public static int yearDiff(String before, String after) {
        Date beforeDay = DateUtil.stringtoDate(before, LONG_DATE_FORMAT);
        Date afterDay = DateUtil.stringtoDate(after, LONG_DATE_FORMAT);
        return DateUtil.getYear(afterDay) - DateUtil.getYear(beforeDay);
    }

    public static int yearDiffCurr(String after) {
        Date beforeDay = new Date();
        Date afterDay = DateUtil.stringtoDate(after, LONG_DATE_FORMAT);
        return DateUtil.getYear(beforeDay) - DateUtil.getYear(afterDay);
    }

    public static long dayDiffCurr(String dateStr) {
        Date currDate = new Date();
        Date date = DateUtil.stringtoDate(dateStr, LONG_DATE_FORMAT);
        return date == null ? 0L : (currDate.getTime() - date.getTime()) / 86400000L;
    }

    public static int getFirstWeekdayOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(7);
        c.set(year, month - 1, 1);
        return c.get(7);
    }

    public static int getLastWeekdayOfMonth(int year, int month) {
        Calendar c = Calendar.getInstance();
        c.setFirstDayOfWeek(7);
        c.set(year, month - 1, DateUtil.getDaysOfMonth(year, month));
        return c.get(7);
    }

    public static String getNow() {
        Calendar today = Calendar.getInstance();
        return DateUtil.dateToString(today.getTime(), FORMAT_ONE);
    }

    public static String getAstro(String birth) {
        if (!DateUtil.isDate((String)birth)) {
            birth = "2000" + (String)birth;
        }
        if (!DateUtil.isDate((String)birth)) {
            return "";
        }
        int month = Integer.parseInt(((String)birth).substring(((String)birth).indexOf("-") + 1, ((String)birth).lastIndexOf("-")));
        int day = Integer.parseInt(((String)birth).substring(((String)birth).lastIndexOf("-") + 1));
        String s = "\u9b54\u7faf\u6c34\u74f6\u53cc\u9c7c\u7261\u7f8a\u91d1\u725b\u53cc\u5b50\u5de8\u87f9\u72ee\u5b50\u5904\u5973\u5929\u79e4\u5929\u874e\u5c04\u624b\u9b54\u7faf";
        int[] arr = new int[]{20, 19, 21, 21, 21, 22, 23, 23, 23, 23, 22, 22};
        int start = month * 2 - (day < arr[month - 1] ? 2 : 0);
        return s.substring(start, start + 2) + "\u5ea7";
    }

    public static boolean isDate(String date) {
        StringBuffer reg = new StringBuffer("^((\\d{2}(([02468][048])|([13579][26]))-?((((0?");
        reg.append("[13578])|(1[02]))-?((0?[1-9])|([1-2][0-9])|(3[01])))");
        reg.append("|(((0?[469])|(11))-?((0?[1-9])|([1-2][0-9])|(30)))|");
        reg.append("(0?2-?((0?[1-9])|([1-2][0-9])))))|(\\d{2}(([02468][12");
        reg.append("35679])|([13579][01345789]))-?((((0?[13578])|(1[02]))");
        reg.append("-?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))");
        reg.append("-?((0?[1-9])|([1-2][0-9])|(30)))|(0?2-?((0?[");
        reg.append("1-9])|(1[0-9])|(2[0-8]))))))");
        Pattern p = Pattern.compile(reg.toString());
        return p.matcher(date).matches();
    }

    public static Date nextMonth(Date date, int months) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(2, months);
        return cal.getTime();
    }

    public static Date nextDay(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(6, day);
        return cal.getTime();
    }

    public static Date nextWeek(Date date, int week) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(4, week);
        return cal.getTime();
    }

    public static String currDay() {
        return DateUtil.dateToString(new Date(), LONG_DATE_FORMAT);
    }

    public static String currTime() {
        return DateUtil.dateToString(new Date(), LONG_TIME_FORMAT);
    }

    public static String befoDay() {
        return DateUtil.befoDay(LONG_DATE_FORMAT);
    }

    public static String befoDay(String format) {
        return DateUtil.dateToString(DateUtil.nextDay(new Date(), -1), format);
    }

    public static String afterDay() {
        return DateUtil.dateToString(DateUtil.nextDay(new Date(), 1), LONG_DATE_FORMAT);
    }

    public static int getDayNum() {
        int daynum = 0;
        GregorianCalendar gd = new GregorianCalendar();
        Date dt = gd.getTime();
        GregorianCalendar gd1 = new GregorianCalendar(1900, 1, 1);
        Date dt1 = gd1.getTime();
        daynum = (int)((dt.getTime() - dt1.getTime()) / 86400000L);
        return daynum;
    }

    public static Date getDateByNum(int day) {
        GregorianCalendar gd = new GregorianCalendar(1900, 1, 1);
        Date date = gd.getTime();
        date = DateUtil.nextDay(date, day);
        return date;
    }

    public static String getYmdDateCN(String datestr) {
        if (datestr == null) {
            return "";
        }
        if (datestr.length() < 10) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(datestr.substring(0, 4)).append(datestr.substring(5, 7)).append(datestr.substring(8, 10));
        return buf.toString();
    }

    public static Map<String, String> getTimeslice(int days) {
        HashMap<String, String> map = new HashMap<String, String>();
        String beforeday = DateUtil.dateToString(DateUtil.nextDay(new Date(), -(days + 1)), LONG_DATE_FORMAT);
        String afterday = DateUtil.befoDay();
        map.put("beforeday", beforeday);
        map.put("afterday", afterday);
        return map;
    }

    public static String[] getDateRange(int datenum) {
        if (datenum < 1) {
            return null;
        }
        String startDate = DateUtil.dateToString(DateUtil.dateSub(5, -datenum), LONG_DATE_FORMAT);
        String endDate = DateUtil.befoDay();
        return new String[]{startDate, endDate};
    }

    public static String[] getDates(int datenum, String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = LONG_DATE_FORMAT;
        }
        String[] dayrange = DateUtil.getDateRange(datenum - 1);
        String startday = dayrange[0];
        String[] xdata = new String[datenum];
        for (int i = 0; i < datenum; ++i) {
            xdata[i] = String.valueOf(DateUtil.getDay(DateUtil.nextDay(DateUtil.stringtoDate(startday, format), i)));
        }
        return xdata;
    }

    public static String[] getDateRangeByPeriod(String period, String startDate, String endDate) {
        Date start = DateUtil.stringtoDate(startDate, LONG_DATE_FORMAT);
        Date end = DateUtil.stringtoDate(endDate, LONG_DATE_FORMAT);
        if (start == null || end == null || !"day".equals(period) && !"week".equals(period) && !"month".equals(period) && !"season".equals(period)) {
            return null;
        }
        Calendar startCal = Calendar.getInstance();
        Calendar endCal = Calendar.getInstance();
        startCal.setTime(start);
        endCal.setTime(end);
        if ("day".equals(period)) {
            return new String[]{startDate, endDate};
        }
        if ("week".equals(period)) {
            startCal.add(5, (9 - startCal.get(7)) % 7);
            endCal.add(5, 1 - endCal.get(7));
        } else if ("month".equals(period)) {
            if (startCal.get(5) != 1) {
                startCal.add(2, 1);
                startCal.set(5, 1);
            }
            endCal.add(5, 1);
            endCal.set(5, 0);
        } else if ("season".equals(period)) {
            if (startCal.get(5) != 1 || startCal.get(2) % 3 != 0) {
                startCal.set(5, 1);
                startCal.add(2, 3 - startCal.get(2) % 3);
            }
            endCal.add(5, 1);
            endCal.set(5, 1);
            endCal.add(2, -endCal.get(2) % 3);
            endCal.add(5, -1);
        }
        if (startCal.compareTo(endCal) > 0) {
            return null;
        }
        return new String[]{DateUtil.dateToString(startCal.getTime(), LONG_DATE_FORMAT), DateUtil.dateToString(endCal.getTime(), LONG_DATE_FORMAT)};
    }

    public static Date nextMinute(Date date, int min) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(12, min);
        return cal.getTime();
    }

    public static String getDateByMillis(long millis, String format) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return DateUtil.dateToString(calendar.getTime(), format);
    }

    public static Date getFirstDayOfMonth(Date date) {
        String dateStr = DateUtil.dateToString(date, LONG_DATE_FORMAT) + " 00:00:00";
        Date day = DateUtil.stringtoDate(dateStr, FORMAT_ONE);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(day);
        calendar.set(5, calendar.getActualMinimum(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getDayMin(Date date) {
        String dateStr = DateUtil.dateToString(date, LONG_DATE_FORMAT) + " 00:00:00";
        Date day = DateUtil.stringtoDate(dateStr, FORMAT_ONE);
        return day;
    }

    public static Date getDayMax(Date date) {
        String dateStr = DateUtil.dateToString(date, LONG_DATE_FORMAT) + " 23:59:59";
        Date day = DateUtil.stringtoDate(dateStr, FORMAT_ONE);
        return day;
    }

    public static Date getYesterday() {
        Date today = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(today);
        int dayOfMonth = calendar.get(5);
        calendar.set(5, dayOfMonth - 1);
        return calendar.getTime();
    }

    public static String[] getRecentDates(int datenum, String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = LONG_DATE_FORMAT;
        }
        String[] dayrange = DateUtil.getDateRange(datenum - 1);
        String startday = dayrange[0];
        String[] xdata = new String[datenum];
        for (int i = 0; i < datenum; ++i) {
            Date date = DateUtil.stringtoDate(startday, LONG_DATE_FORMAT);
            Date nextdate = DateUtil.nextDay(date, i);
            xdata[i] = DateUtil.dateToString(nextdate, format);
        }
        return xdata;
    }

    public static Date getLastDateOfYear(Date date) {
        Date dayMax = DateUtil.getDayMax(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dayMax);
        calendar.set(2, 11);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static long getMillisByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.getTimeInMillis();
    }

    public static int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMiniute(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static Date getFirstDateOfLastMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int lastmonth = calendar.get(2) - 1;
        calendar.set(2, lastmonth);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static long getDaysApart(Date date1, Date date2) {
        String date1String = DateUtil.dateToString(date1, LONG_DATE_FORMAT);
        String date2String = DateUtil.dateToString(date2, LONG_DATE_FORMAT);
        Date fstDate = DateUtil.stringtoDate(date1String, LONG_DATE_FORMAT);
        Date sndDate = DateUtil.stringtoDate(date2String, LONG_DATE_FORMAT);
        return (sndDate.getTime() - fstDate.getTime()) / 86400000L;
    }

    public static String[] getRecentMonths(int monthnum, String format) {
        if (StringUtils.isBlank((CharSequence)format)) {
            format = LONG_DATE_FORMAT;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, -(monthnum + 1));
        String[] months = new String[monthnum];
        for (int i = 0; i < monthnum; ++i) {
            calendar.add(2, 1);
            Date month = calendar.getTime();
            months[i] = DateUtil.dateToString(month, format);
        }
        return months;
    }
}

