/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.session;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;

@Configuration
public class AradinSessionConfiguration {
    @Value(value="${spring.session.cookie.name:SESSION}")
    private String cookieName;
    @Value(value="${spring.session.cookie.max-age:1800}")
    private Integer maxAge;
    @Value(value="${spring.session.cookie.domain:}")
    private String domain;
    @Value(value="${spring.session.cookie.http-only:true}")
    private Boolean httpOnly;
    @Value(value="${spring.session.cookie.security:true}")
    private Boolean security;
    @Value(value="${spring.session.cookie.same-site:Lax}")
    private String sameSite;

    @Bean
    public CookieSerializer createDefaultCookieSerializer() {
        DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
        if (StringUtils.isNotBlank((CharSequence)this.cookieName)) {
            cookieSerializer.setCookieName(this.cookieName);
            if (this.maxAge != null && this.maxAge > 0) {
                cookieSerializer.setCookieMaxAge(this.maxAge.intValue());
            }
            if (StringUtils.isNotBlank((CharSequence)this.domain)) {
                cookieSerializer.setDomainName(this.domain);
            }
            cookieSerializer.setUseHttpOnlyCookie(this.httpOnly.booleanValue());
            cookieSerializer.setSameSite(this.sameSite);
            if ("None".equals(this.sameSite)) {
                cookieSerializer.setUseSecureCookie(true);
            } else {
                cookieSerializer.setUseSecureCookie(this.security.booleanValue());
            }
        }
        return cookieSerializer;
    }
}

