/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.queue;

import cn.aradin.spring.core.queue.QueueHandler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class AradinQueue<T>
extends Thread {
    private ReentrantLock newItemLock = new ReentrantLock();
    private Condition newItemCondition = this.newItemLock.newCondition();
    private long waittime = 10000L;
    private QueueHandler<T> queueHandler = null;
    private String queuename;

    public AradinQueue(QueueHandler<T> queueHandler, long waittime, String queuename) {
        this.queueHandler = queueHandler;
        this.waittime = waittime;
        this.queuename = queuename;
        queueHandler.setName(queuename);
    }

    public void pushItem(T t) {
        this.queueHandler.pushItem(t);
        this.signalNewItem();
    }

    public void waitNewItem() {
        this.newItemLock.lock();
        try {
            this.newItemCondition.await(this.waittime, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.newItemLock.unlock();
        }
    }

    public void signalNewItem() {
        try {
            this.newItemLock.lock();
            this.newItemCondition.signalAll();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.newItemLock.unlock();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                Thread.currentThread();
                if (!Thread.interrupted()) {
                    try {
                        T t = this.queueHandler.popItem();
                        if (t == null) {
                            this.waitNewItem();
                            continue;
                        }
                        this.queueHandler.handle(t);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(this.queuename + "_AradinQueue thread exit\uff01\uff01\uff01");
    }

    public String queuename() {
        return this.queuename;
    }
}

