/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.context.strategy;

import cn.aradin.spring.core.context.AradinContext;
import cn.aradin.spring.core.context.AradinContextImpl;
import cn.aradin.spring.core.context.strategy.AradinContextHolderStrategy;
import org.springframework.util.Assert;

public class InheritableThreadLocalAradinContextHolderStrategy
implements AradinContextHolderStrategy {
    private static final ThreadLocal<AradinContext> contextHolder = new InheritableThreadLocal<AradinContext>();

    @Override
    public void clearContext() {
        contextHolder.remove();
    }

    @Override
    public AradinContext getContext() {
        AradinContext ctx = contextHolder.get();
        if (ctx == null) {
            ctx = this.createEmptyContext();
            contextHolder.set(ctx);
        }
        return ctx;
    }

    @Override
    public void setContext(AradinContext context) {
        Assert.notNull((Object)context, (String)"Only non-null AradinContext instances are permitted");
        contextHolder.set(context);
    }

    @Override
    public AradinContext createEmptyContext() {
        return new AradinContextImpl();
    }
}

