/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.context.holder;

import cn.aradin.spring.core.context.AradinContext;
import cn.aradin.spring.core.context.strategy.AradinContextHolderStrategy;
import cn.aradin.spring.core.context.strategy.GlobalAradinContextHolderStrategy;
import cn.aradin.spring.core.context.strategy.InheritableThreadLocalAradinContextHolderStrategy;
import cn.aradin.spring.core.context.strategy.ThreadLocalAradinContextHolderStrategy;
import java.lang.reflect.Constructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ReflectionUtils;

public class AradinContextHolder {
    public static final String MODE_THREADLOCAL = "MODE_THREADLOCAL";
    public static final String MODE_INHERITABLETHREADLOCAL = "MODE_INHERITABLETHREADLOCAL";
    public static final String MODE_GLOBAL = "MODE_GLOBAL";
    public static final String SYSTEM_PROPERTY = "aradin.context.strategy";
    private static String strategyName = System.getProperty("aradin.context.strategy");
    private static AradinContextHolderStrategy strategy;
    private static int initializeCount;

    public static void clearContext() {
        strategy.clearContext();
    }

    public static AradinContext getContext() {
        return strategy.getContext();
    }

    public static int getInitializeCount() {
        return initializeCount;
    }

    private static void initialize() {
        if (StringUtils.isBlank((CharSequence)strategyName)) {
            strategyName = MODE_THREADLOCAL;
        }
        if (strategyName.equals(MODE_THREADLOCAL)) {
            strategy = new ThreadLocalAradinContextHolderStrategy();
        } else if (strategyName.equals(MODE_INHERITABLETHREADLOCAL)) {
            strategy = new InheritableThreadLocalAradinContextHolderStrategy();
        } else if (strategyName.equals(MODE_GLOBAL)) {
            strategy = new GlobalAradinContextHolderStrategy();
        } else {
            try {
                Class<?> clazz = Class.forName(strategyName);
                Constructor<?> customStrategy = clazz.getConstructor(new Class[0]);
                strategy = (AradinContextHolderStrategy)customStrategy.newInstance(new Object[0]);
            }
            catch (Exception ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
        }
        ++initializeCount;
    }

    public static void setContext(AradinContext context) {
        strategy.setContext(context);
    }

    public static void setStrategyName(String strategyName) {
        AradinContextHolder.strategyName = strategyName;
        AradinContextHolder.initialize();
    }

    public static AradinContextHolderStrategy getContextHolderStrategy() {
        return strategy;
    }

    public static AradinContext createEmptyContext() {
        return strategy.createEmptyContext();
    }

    public String toString() {
        return "AradinContextHolder[strategy='" + strategyName + "'; initializeCount=" + initializeCount + "]";
    }

    static {
        initializeCount = 0;
        AradinContextHolder.initialize();
    }
}

