/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static List<List<String>> parseSheet(Integer sheetindex, Integer startrow, Integer startcel, String filename) {
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        try {
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(filename);
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(sheetindex.intValue());
            if (xssfSheet == null) {
                return null;
            }
            for (int rowNum = startrow.intValue(); rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                if (xssfRow == null) continue;
                ArrayList<String> cellcontent = new ArrayList<String>();
                for (int cellNum = startcel.intValue(); cellNum <= xssfRow.getLastCellNum(); ++cellNum) {
                    XSSFCell xssfCell = xssfRow.getCell(cellNum);
                    if (xssfCell == null) {
                        cellcontent.add("");
                        continue;
                    }
                    cellcontent.add(ExcelUtil.getValue(xssfCell));
                    if (!log.isDebugEnabled()) continue;
                    log.debug("{},{}", (Object)cellNum, (Object)ExcelUtil.getValue(xssfCell));
                }
                content.add(cellcontent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public static List<List<String>> parseSheet(Integer sheetindex, Integer startrow, String filename) {
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        try {
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(filename);
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(sheetindex.intValue());
            if (xssfSheet == null) {
                return null;
            }
            for (int rowNum = startrow.intValue(); rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                if (xssfRow == null) continue;
                ArrayList<String> cellcontent = new ArrayList<String>();
                for (int cellNum = 0; cellNum <= xssfRow.getLastCellNum(); ++cellNum) {
                    XSSFCell xssfCell = xssfRow.getCell(cellNum);
                    if (xssfCell == null) {
                        cellcontent.add("");
                        continue;
                    }
                    cellcontent.add(ExcelUtil.getValue(xssfCell));
                    if (!log.isDebugEnabled()) continue;
                    log.debug("{},{}", (Object)cellNum, (Object)ExcelUtil.getValue(xssfCell));
                }
                content.add(cellcontent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    public static List<List<String>> parseSheet(Integer sheetindex, Integer startrow, InputStream ins) {
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        try {
            XSSFWorkbook xssfWorkbook = new XSSFWorkbook(ins);
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(sheetindex.intValue());
            if (xssfSheet == null) {
                return null;
            }
            for (int rowNum = startrow.intValue(); rowNum <= xssfSheet.getLastRowNum(); ++rowNum) {
                XSSFRow xssfRow = xssfSheet.getRow(rowNum);
                if (xssfRow == null) continue;
                ArrayList<String> cellcontent = new ArrayList<String>();
                for (int cellNum = 0; cellNum <= xssfRow.getLastCellNum(); ++cellNum) {
                    XSSFCell xssfCell = xssfRow.getCell(cellNum);
                    if (xssfCell == null) {
                        cellcontent.add("");
                        continue;
                    }
                    cellcontent.add(ExcelUtil.getValue(xssfCell));
                    if (!log.isDebugEnabled()) continue;
                    log.debug("{},{}", (Object)cellNum, (Object)ExcelUtil.getValue(xssfCell));
                }
                content.add(cellcontent);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    private static String getValue(XSSFCell xssfCell) {
        if (xssfCell.getCellType() == CellType.BOOLEAN) {
            return String.valueOf(xssfCell.getBooleanCellValue());
        }
        if (xssfCell.getCellType() == CellType.NUMERIC) {
            return String.valueOf((long)xssfCell.getNumericCellValue());
        }
        return String.valueOf(xssfCell.getStringCellValue());
    }

    public static void createSheet(String filepath, String sheetname, String[] cellnames, List<List<Object>> arrRows) throws Exception {
        FileOutputStream fout = null;
        try {
            File file = new File(filepath);
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            fout = new FileOutputStream(file);
            ExcelUtil.createSheet(fout, sheetname, cellnames, arrRows);
        }
        catch (Exception e) {
            throw new Exception("\u4fdd\u5b58excel\u5931\u8d25");
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    public static void createSheet(OutputStream outputStream, String sheetname, String[] cellnames, List<List<Object>> arrRows) throws Exception {
        int i;
        XSSFWorkbook xb = new XSSFWorkbook();
        XSSFSheet sheet = xb.createSheet(sheetname);
        XSSFRow row = sheet.createRow(0);
        XSSFCellStyle style = xb.createCellStyle();
        style.setAlignment(HorizontalAlignment.CENTER);
        if (cellnames == null || cellnames.length <= 0) {
            throw new Exception("\u8868\u5934\u4fe1\u606f\u4e3a\u7a7a");
        }
        for (i = 0; i < cellnames.length; ++i) {
            XSSFCell cell = row.createCell(i);
            cell.setCellValue(cellnames[i]);
            cell.setCellStyle((CellStyle)style);
        }
        if (arrRows != null && arrRows.size() > 0) {
            for (i = 0; i < arrRows.size(); ++i) {
                List<Object> rowdata = arrRows.get(i);
                row = sheet.createRow(i + 1);
                for (int j = 0; j < rowdata.size(); ++j) {
                    Object value = rowdata.get(j);
                    if (value instanceof Double) {
                        row.createCell(j).setCellValue(((Double)rowdata.get(j)).doubleValue());
                        continue;
                    }
                    row.createCell(j).setCellValue((String)rowdata.get(j));
                }
            }
        }
        try {
            xb.write(outputStream);
            outputStream.flush();
        }
        catch (Exception e) {
            throw new Exception("\u4fdd\u5b58excel\u5931\u8d25");
        }
    }
}

