/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.rowmap;

import com.google.common.collect.Lists;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Row
extends HashMap<Object, Object> {
    protected List<Object> ordering = Lists.newArrayList();
    protected Map<String, String> functionMap = null;
    private final Map<Object, List> _fields = new HashMap<Object, List>();

    public Row() {
    }

    public Row(Map<?, ?> map) {
        super(map);
        for (Object obj : map.keySet()) {
            this.ordering.add(obj);
        }
    }

    public String gets(Object name) {
        try {
            if (this.get(name) != null) {
                return this.get(name).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public String gets(Object name, String defaultValue) {
        try {
            if (this.get(name) != null) {
                return this.get(name).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public String gets(Object name, String enc, String defaultValue) {
        try {
            if (this.get(name) != null) {
                return URLDecoder.decode(this.get(name).toString(), enc);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public Integer getInt(Object name) {
        Object o = this.get(name);
        if (o != null) {
            try {
                return Integer.parseInt(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public int getInt(Object name, int defaultValue) {
        Object o = this.get(name);
        if (o != null) {
            try {
                return Integer.parseInt(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public boolean getBoolean(Object name, boolean defaultValue) {
        Object o = this.get(name);
        if (o != null) {
            try {
                return Boolean.parseBoolean(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public int getInt(int which, int defaultValue) {
        Object key = this.ordering.get(which);
        return this.getInt(key, defaultValue);
    }

    public float getFloat(Object name) {
        return Float.valueOf(this.get(name).toString()).floatValue();
    }

    public float getFloat(Object name, float defaultValue) {
        Object o = this.get(name);
        if (o != null) {
            try {
                return Float.valueOf(o.toString()).floatValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public float getFloat(int which, float defaultValue) {
        Object key = this.ordering.get(which);
        return this.getFloat(key, defaultValue);
    }

    public Long getLong(Object name) {
        Object o = this.get(name);
        if (o != null) {
            try {
                return (long)Long.valueOf(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public long getLong(Object name, long defaultValue) {
        Object o = this.get(name);
        if (o != null) {
            try {
                return Long.valueOf(o.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public Object get(int which) {
        Object key = this.ordering.get(which);
        return this.get(key);
    }

    public Object getKey(int which) {
        Object key = this.ordering.get(which);
        return key;
    }

    public String[] getKeys() {
        Set keys = this.keySet();
        Iterator iter = keys.iterator();
        String[] strs = new String[keys.size()];
        int i = 0;
        while (iter.hasNext()) {
            strs[i] = iter.next().toString();
            ++i;
        }
        return strs;
    }

    public void dump() {
        for (String name : this.keySet()) {
            Object value = this.get(name);
            System.out.println(name + "=" + value + ", ");
        }
    }

    public String dumpToString() {
        StringBuffer sb = new StringBuffer();
        for (String name : this.keySet()) {
            Object value = this.get(name);
            sb.append(value).append(",");
        }
        return sb.toString();
    }

    @Override
    public Object put(Object name, Object value) {
        if (!this.containsKey(name)) {
            this.ordering.add(name);
        }
        super.put(name, value);
        if (this.functionMap != null && this.functionMap.containsKey(name)) {
            this.functionMap.remove(name);
        }
        return value;
    }

    public int putInt(Object name, int value) {
        super.put(name, value);
        return value;
    }

    public float putFloat(Object name, float value) {
        super.put(name, Float.valueOf(value));
        return value;
    }

    public String putFunction(String name, String value) {
        if (this.functionMap == null) {
            this.functionMap = new HashMap<String, String>();
        }
        if (this != null && this.containsKey(name)) {
            this.remove(name);
        }
        this.functionMap.put(name, value);
        return value;
    }

    public String getFunction(String name) {
        return this.functionMap.get(name);
    }

    public Map<String, String> getFunctionMap() {
        return this.functionMap;
    }

    public void setFunctionMap(HashMap<String, String> fmap) {
        if (fmap != null && fmap.size() > 0) {
            if (this.functionMap == null) {
                this.functionMap = new HashMap<String, String>();
            }
            this.functionMap.putAll(fmap);
        }
    }

    @Override
    public void putAll(Map<?, ?> otherMap) {
        Set<?> keySet = otherMap.keySet();
        for (Object name : keySet) {
            this.ordering.add(name);
        }
        super.putAll(otherMap);
    }

    @Override
    public Object remove(Object name) {
        if (this.ordering.remove(name)) {
            return super.remove(name);
        }
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.ordering.clear();
    }

    public int length() {
        return this.size();
    }

    public void append(Object key, Object value) {
        if (!this.containsKey(key)) {
            this.ordering.add(key);
            super.put(key, value);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(value);
            this._fields.put(key, list);
        } else {
            this._fields.get(key).add(value);
            super.put(key, this._fields.get(key));
        }
    }

    public List<?> getList(Object key) {
        Object obj = this.get(key);
        if (obj != null) {
            return (List)obj;
        }
        return null;
    }
}

