/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.bean.support;

import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.YamlPropertiesFactoryBean;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.DefaultPropertySourceFactory;
import org.springframework.core.io.support.EncodedResource;

public class AradinPropertySourceFactory
extends DefaultPropertySourceFactory {
    private static final Logger log = LoggerFactory.getLogger(AradinPropertySourceFactory.class);

    public PropertySource<?> createPropertySource(String name, EncodedResource resource) throws IOException {
        String sourceName;
        String string = sourceName = name != null ? name : resource.getResource().getFilename();
        if (log.isDebugEnabled()) {
            log.debug("Register Property {}", (Object)sourceName);
        }
        if (!resource.getResource().exists()) {
            if (log.isDebugEnabled()) {
                log.debug("Resource Not Exsit{}", (Object)sourceName);
            }
            return new PropertiesPropertySource(sourceName, new Properties());
        }
        if (sourceName.endsWith(".yml") || sourceName.endsWith(".yaml")) {
            if (log.isDebugEnabled()) {
                log.debug("Found YML {}", (Object)sourceName);
            }
            Properties propertiesFromYaml = this.loadYml(resource);
            return new PropertiesPropertySource(sourceName, propertiesFromYaml);
        }
        if (log.isDebugEnabled()) {
            log.debug("Found Property {}", (Object)sourceName);
        }
        return super.createPropertySource(name, resource);
    }

    private Properties loadYml(EncodedResource resource) throws IOException {
        YamlPropertiesFactoryBean factory = new YamlPropertiesFactoryBean();
        factory.setResources(new Resource[]{resource.getResource()});
        factory.afterPropertiesSet();
        return factory.getObject();
    }
}

