/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.net.http.handler;

import com.alibaba.fastjson2.JSONObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(ResponseHandlerFactory.class);
    private static Map<String, ResponseHandler<Object>> map = new HashMap<String, ResponseHandler<Object>>();

    public static ResponseHandler<Object> createJsonResponseHandler(final Class<?> clazz) {
        if (map.containsKey(clazz.getName())) {
            return map.get(clazz.getName());
        }
        ResponseHandler<Object> responseHandler = new ResponseHandler<Object>(){

            public Object handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                int status = response.getStatusLine().getStatusCode();
                if (status >= 200 && status < 300) {
                    HttpEntity entity = response.getEntity();
                    String str = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName("utf-8"));
                    if (log.isDebugEnabled()) {
                        log.debug("HTTP Result\uff1a{}", (Object)str);
                    }
                    if (String.class.equals((Object)clazz)) {
                        return str;
                    }
                    if (Integer.class.equals((Object)clazz)) {
                        return Integer.parseInt(str);
                    }
                    if (Long.class.equals((Object)clazz)) {
                        return Long.parseLong(str);
                    }
                    return JSONObject.parseObject((String)str, (Class)clazz);
                }
                throw new ClientProtocolException("Unexpected response status: " + status);
            }
        };
        map.put(clazz.getName(), responseHandler);
        return responseHandler;
    }
}

