/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.bean;

import com.alibaba.fastjson.parser.ParserConfig;
import java.beans.Introspector;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Component
public class AradinBeanFactory
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AradinBeanFactory.class);
    private static ApplicationContext applicationContext = null;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (AradinBeanFactory.applicationContext == null) {
            AradinBeanFactory.applicationContext = applicationContext;
        }
        if (log.isDebugEnabled()) {
            log.debug("Context\u521d\u59cb\u5316");
        }
        ParserConfig.getGlobalInstance().setAutoTypeSupport(false);
    }

    public static ApplicationContext getApplicationContext() {
        while (applicationContext == null) {
            if (log.isDebugEnabled()) {
                log.debug("\u7b49\u5f85Context\u521d\u59cb\u5316\u300b\u300b\u300b\u8bf7\u589e\u52a0{}", (Object)"@DependsOn(\"beanUtil\")");
            }
            try {
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return applicationContext;
    }

    public static Object getBean(String name) {
        return AradinBeanFactory.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)AradinBeanFactory.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)AradinBeanFactory.getApplicationContext().getBean(name, clazz);
    }

    public static <T> T getPrefixBean(String prefix, Class<T> clazz) {
        return AradinBeanFactory.getPrefixBean(prefix, clazz, null);
    }

    public static <T> T getPrefixBean(String prefix, Class<T> clazz, String pathPrefix) {
        if (applicationContext != null) {
            String path = ClassUtils.getPackageName(clazz);
            if (StringUtils.isNotBlank((CharSequence)pathPrefix) && !path.contains(pathPrefix)) {
                return null;
            }
            String shortClassName = ClassUtils.getShortName((String)clazz.getName());
            String beanName = prefix + Introspector.decapitalize(shortClassName);
            return (T)applicationContext.getBean(beanName, clazz);
        }
        return null;
    }
}

