/*
 * Decompiled with CFR 0.152.
 */
package cn.aradin.spring.core.algo;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class SWRRMethod {
    private List<SWRRObj> objs = Lists.newArrayList();
    private List<Integer> datas = Lists.newArrayList();
    private Integer sum = 0;
    private boolean hasNext = true;

    public SWRRMethod(List<Integer> datas) {
        if (CollectionUtils.isNotEmpty(datas)) {
            this.datas = datas;
            for (int i = 0; i < datas.size(); ++i) {
                SWRRObj obj = new SWRRObj(i, datas.get(i));
                this.objs.add(obj);
            }
            this.sum = this.objs.stream().mapToInt(SWRRObj::getValue).sum();
        }
    }

    public Integer next() {
        if (this.hasNext && CollectionUtils.isNotEmpty(this.objs)) {
            SWRRObj newMax;
            SWRRObj maxObj = Collections.max(this.objs, new Comparator<SWRRObj>(){

                @Override
                public int compare(SWRRObj o1, SWRRObj o2) {
                    return o1.value - o2.value;
                }
            });
            Integer result = this.datas.get(maxObj.getIndex());
            maxObj.setValue(maxObj.getValue() - this.sum);
            if (maxObj.getValue().equals(0) && (newMax = Collections.max(this.objs, new Comparator<SWRRObj>(){

                @Override
                public int compare(SWRRObj o1, SWRRObj o2) {
                    return o1.value - o2.value;
                }
            })).getValue().equals(0)) {
                this.hasNext = false;
            }
            this.objs.forEach(obj -> obj.setValue(obj.getValue() + this.datas.get(obj.getIndex())));
            return result;
        }
        return null;
    }

    public static final void main(String[] args) {
        ArrayList datas = Lists.newArrayList();
        datas.add(1);
        datas.add(3);
        datas.add(5);
        datas.add(2);
        SWRRMethod method = new SWRRMethod(datas);
        Integer cursor = 0;
        while ((cursor = method.next()) != null) {
            System.out.println(cursor);
            System.out.println(JSONObject.toJSONString(method.objs));
        }
    }

    class SWRRObj {
        private Integer index;
        private Integer value;

        public SWRRObj(Integer index, Integer value) {
            this.index = index;
            this.value = value;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public Integer getValue() {
            return this.value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }
    }
}

